<!DOCTYPE html>
<html <?php language_attributes(); ?> class="home-one">
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="robots" content="index,follow">

  <!-- Dynamic Title -->
  <title><?php wp_title('|', true, 'right'); bloginfo('name'); ?></title>

  <!-- Dynamic Description and Keywords (Optional: for SEO plugins to override) -->
  <meta name="description" content="IT Solution, Sass and Multipurpose HTML Template">
  <meta name="keywords" content="IT Solution, Sass and Multipurpose HTML Template">

  <!-- Favicon -->
  <link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/assets/images/logo/favicon.png">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/aos.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/swiper-bundle.min.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/magnific-popup.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/satoshi.css">
  <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css">

  <!-- WordPress Hook for Plugins and Additional Scripts -->
  <?php wp_head(); ?>
</head>

<body>
    
<!--==================== Preloader Start ====================-->
  <div class="preloader">
    <div class="cssload-loading"><i></i><i></i><i></i><i></i></div>
  </div>
<!--==================== Preloader End ====================-->

<!--==================== Overlay Start ====================-->
<div class="overlay"></div>
<!--==================== Overlay End ====================-->

<!--==================== Sidebar Overlay End ====================-->
<div class="side-overlay"></div>
<!--==================== Sidebar Overlay End ====================-->

<!-- Custom Toast Message start -->
<div id="toast-container"></div>
<!-- Custom Toast Message End -->

<!-- ==================== Scroll to Top End Here ==================== -->
<div class="progress-wrap">
  <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
      <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
  </svg>
</div>
<!-- ==================== Scroll to Top End Here ==================== -->

<!-- Custom Cursor Start -->
  <div class="cursor"></div>
  <span class="dot"></span>
<!-- Custom Cursor End -->
<!-- ==================== Mobile Menu Start Here ==================== -->
<div class="mobile-menu d-lg-none d-block scroll-sm position-fixed bg-white tw-w-300-px tw-h-screen overflow-y-auto tw-p-6 tw-z-999 tw--translate-x-full tw-pb-68 ">

    <button type="button" class="close-button position-absolute tw-end-0 top-0 tw-me-2 tw-mt-2 tw-w-605 tw-h-605 rounded-circle d-flex justify-content-center align-items-center text-neutral-900 bg-neutral-200 hover-bg-neutral-900 hover-text-white"> 
        <i class="ph ph-x"></i>
    </button>

    <div class="mobile-menu__inner">
        <a href="index.html" class="mobile-menu__logo">
            <img src="https://malikubaid.com/wp/wp-content/uploads/2025/06/malikubaid_logo.png" alt="Malik Ubaid Logo">
        </a>
        <div class="mobile-menu__menu">
            <!-- Nav menu Start -->
<?php
  wp_nav_menu(array(
    'theme_location' => 'mobile',
    'container'      => false,
    'menu_class'     => 'nav-menu d-block tw-mt-8',
    'walker'         => new Mobile_Walker_Nav_Menu()
  ));
  ?>
<!-- Nav menu End  -->

        </div>
        <a href="register.html" class="btn btn-main-two hover-style-two button--stroke d-sm-none d-inline-flex align-items-center justify-content-center tw-gap-5 group active--translate-y-2 tw-px-8 rounded-pill tw-mt-6" data-block="button">
            <span class="button__flair"></span>
            <span class="button__label">Sign Up Now</span>
        </a>
    </div>
</div>
<!-- ==================== Mobile Menu End Here ==================== -->



<div id="smooth-wrapper">
    
    <!-- ========================== Top Header Start ============================== -->
<div class="bg-main-600 tw-py-205 d-sm-block d-none">
    <div class="container">
        <div class="d-flex justify-content-center">
            <p class="text-white bg-white-13 d-inline-block tw-py-1 tw-px-5 rounded-pill fw-normal">We're introducing an exceptionally crafted UI/UX template on ThemeForest, designed to deliver outstanding conversion results!</p>
        </div>
    </div>
</div>
<!-- ========================== Top Header End ============================== -->

    <!-- ==================== Header Start Here ==================== -->
<header class="header bg-white transition-all">
    <div class="container container-two">
        <nav class="d-flex align-items-center justify-content-between">
            <!-- Logo Start -->
            <div class="logo">
                <a href="index.html" class="link hover--translate-y-1 active--translate-y-scale-9">
                    <img src="https://malikubaid.com/wp/wp-content/uploads/2025/06/malikubaid_logo.png" alt="Malik Ubaid Logo" class="max-w-200-px">
                </a>
            </div>
            <!-- Logo End  -->

            <!-- Menu Start  -->
            <div class="header-menu d-lg-block d-none">
                <!-- Nav menu Start -->
<?php
wp_nav_menu(array(
    'theme_location'  => 'primary',
    'menu_class'      => 'nav-menu d-lg-flex align-items-center tw-gap-14',
    'container'       => false,
    'walker'          => new Custom_Walker_Nav_Menu()
));
?>
<!-- Nav menu End  -->

            </div>
            <!-- Menu End  -->

            <!-- Header Right start -->
             <div class="d-flex align-items-center tw-gap-6">
                <a href="register.html" class="hover--translate-y-1 active--translate-y-scale-9 btn btn-main-two hover-style-two button--stroke d-sm-inline-flex d-none align-items-center justify-content-center tw-gap-5 group active--translate-y-2 tw-px-9 rounded-pill tw-py-4 fw-semibold" data-block="button">
                    <span class="button__flair"></span>
                    <span class="button__label">Sign Up Now</span>
                </a>
                <button type="button" class="toggle-mobileMenu leading-none d-lg-none text-neutral-800 tw-text-9"> 
                    <i class="ph ph-list"></i>
                </button>
             </div>
            <!-- Header Right End  -->
        </nav>
    </div>
</header>
<!-- ==================== Header End Here ==================== -->