(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Accordion;

        KFW_Accordion = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main            : '.kfw-ele-widget-accordion-main',
                        accordionItem   : '.kfw-elementor-accordion-item',
                        accordionTitle  : '.kfw-accordion-header-wrap',
                        accordionContent: '.kfw-accordion-content-wrap',
                    },
                    classes: {
                        active: 'kfw-elementor-active-accordion',
                    },
                    showTabFn: 'slideDown', //slideDown, show
                    hideTabFn: 'slideUp', // slideUp, hide
                    isAnimating: false, // isAnimating variable is used to track whether an animation is in progress.
                }
            },

            getDefaultElements() {
                const { main, accordionItem, accordionTitle, accordionContent } = this.getSettings( 'selectors' );
                return {
                    $frontSettings   : this.getSettings().$element.data("settings"),
                    $main            : this.findElement( main ),
                    $accordionItem   : this.findElement( accordionItem ),
                    $accordionTitle  : this.findElement( accordionTitle ),
                    $accordionContent: this.findElement( accordionContent ),
                }
            },

            bindEvents: function () {
                let $this         = this;
                let $multipleOpen = $this.elements.$main.data('multipleOpen');

                $this._activateDefaultItem();

                $this.elements.$accordionItem.on({
                    click: ( event ) => {
                        event.preventDefault();

                        if( !$this.getSettings( 'isAnimating' ) ) {
                            $this.setSettings( 'isAnimating', true );
                            this._changeActiveItem( event.currentTarget.getAttribute( 'data-id' ), $multipleOpen );
                        }
                    },
                });
            },

            _changeActiveItem( $itemIndex, $multipleOpen  ) {
                console.log( $multipleOpen );

                const $isActiveItem = this._isActiveItem( $itemIndex );
                const $toggleSelf   = true;
                const $hidePrevious = !$multipleOpen;

                console.log( $hidePrevious );

                if ( ( $toggleSelf || ! $isActiveItem ) && $hidePrevious ) {
                    this._deactivateActiveItem();
                }

                if ( ! $hidePrevious && $isActiveItem ) {
                    this._deactivateActiveItem( $itemIndex );
                }

                if ( ! $isActiveItem ) {
                    this._activateItem( $itemIndex );
                }
            },

            _deactivateActiveItem( $itemIndex ) {
                const $this          = this;
                const $activeClass   = $this.getSettings( 'classes.active' );
                const $activeFilter  = $itemIndex ? '[data-id="' + $itemIndex + '"]' : '.' + $activeClass;
                const $activeItem    = $this.elements.$accordionItem.filter( $activeFilter );
                const $activeContent = $this.elements.$accordionContent.filter( $activeFilter );

                $activeItem.add($activeContent).removeClass( $activeClass );
                $activeContent[ $this.getSettings( 'hideTabFn' ) ](300,function(){ $this.setSettings( 'isAnimating', false ); });
                $activeContent.attr( 'hidden', 'hidden' );
            },

            _activateDefaultItem() {
                const $itemIndex = this.elements.$main.attr('data-default-item');
                if( $itemIndex.length ) {
                    this._activateItem( $itemIndex );
                }
            },

            _activateItem( $itemIndex ) {
                const $this             = this;
                const $activeClass      = $this.getSettings( 'classes.active' );
                const $requestedItem    = $this.elements.$accordionItem.filter( '[data-id="' + $itemIndex + '"]' );
                const $requestedContent = $this.elements.$accordionContent.filter( '[data-id="' + $itemIndex + '"]' );

                $requestedItem.add($requestedContent).addClass( $activeClass );
                $requestedContent[ $this.getSettings( 'showTabFn' ) ](300,function(){ $this.setSettings( 'isAnimating', false ); });
                $requestedContent.removeAttr( 'hidden' );
            },

            _isActiveItem( $itemIndex ) {
                return this.elements.$accordionItem
                    .filter( '[data-id="' + $itemIndex + '"]' )
                    .hasClass( this.getSettings( 'classes.active' ) );
            },

            _isBool($arg ) {
                switch( $arg ) {
                    case true:
                    case "true":
                    case "TRUE":
                    case 1:
                    case "1":
                    case "on":
                    case "ON":
                    case "yes":
                    case "YES":
                    case "right":
                    case "RIGHT":
                        return true;

                    default:
                        return false;
                }
            },

        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-accordion', KFW_Accordion );
    });
})( jQuery, window.elementorFrontend );