(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler      = elementorModules.frontend.handlers.Base,
            KFW_Content_Switch;

            KFW_Content_Switch = moduleHandler.extend({
                getDefaultSettings() {
                    return {
                        selectors: {
                            main    : '.kfw-ele-widget-content-switch-main',
                            switcher: '.kfw-switch',
                        }
                    }
                },

                getDefaultElements() {
                    const { main, switcher } = this.getSettings( 'selectors' );

                    return {
                        $main  : this.$element.find( main ),
                        $switch: this.$element.find( switcher ),
                    }
                },

                bindEvents: function () {
                    this._execute();
                },

                _execute: function() {
                    let $this   = this,
                        $id     = $this.getID(),
                        $main   = $this.elements.$main,
                        $switch = $this.elements.$switch;

                    let $primary   = $this.findElement('.kfw-primary-content'),
                        $secondary = $this.findElement('.kfw-secondary-content');

                    $($switch).on('click',function(){
                        let $this = $(this);

                        if( $this.hasClass( 'kinfw-primary-switch' ) ) {
                            $this
                                .addClass( 'kinfw-secondary-switch' )
                                .removeClass( 'kinfw-primary-switch' );

                            $primary.removeClass('active');
                            $secondary.addClass('active');
                        } else if( $this.hasClass( 'kinfw-secondary-switch' ) ) {
                            $this
                                .addClass( 'kinfw-primary-switch' )
                                .removeClass( 'kinfw-secondary-switch' );

                            $primary.addClass('active');
                            $secondary.removeClass('active');
                        }
                    });

                },
            });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-content-switch', KFW_Content_Switch );
    });
})( jQuery, window.elementorFrontend );
