(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler       = elementorModules.frontend.handlers.Base,
            KFW_CPT_Team_Member_Carousel;

        KFW_CPT_Team_Member_Carousel = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main  : '.kfw-ele-widget-cpt-team-member-carousel-main',
                        swiper: '.kfw-swiper',
                    }
                }
            },

            getDefaultElements() {
                const { main, swiper } = this.getSettings( 'selectors' );

                return {
                    $main  : this.$element.find( main ),
                    $swiper: this.$element.find( swiper ),
                }
            },

            bindEvents: function () {
                if( typeof( Swiper ) !== 'function' ) {
                    return;
                }

                let $isEdit = this.isEdit ? true : false;

                if( $isEdit ) {
                    this._copyToClipboard();
                }

                this._execute();
            },

            _copyToClipboard: function() {
                let $this = this,
                    $main = $this.elements.$main;

                let $clickable = $(".kfw-js-clickable", $main );

                $clickable.on("click",function(){
                    var $textToCopy = $(this).text().trim();

                    // Create a temporary input element
                    var tempInput = $('<input>');
                    $('body').append(tempInput);
                    tempInput.val($textToCopy).select();

                    // Execute copy command
                    document.execCommand('copy');

                    // Remove temporary input element
                    tempInput.remove();

                    alert($textToCopy + 'class copied' );
                });
            },

            _execute: function() {
                let $this       = this,
                    $id         = $this.getID(),
                    $main       = $this.elements.$main,
                    $swiper     = $this.elements.$swiper;

                let $settings = $main.data('settings'),
                    $items    = $(".kfw-ele-widget-cpt-team-member-carousel-item", $swiper);

                if( $items.length > 1 ) {
                    let $class  = $swiper.data("id"),
                        $len    = $class.length + 1,
                        $sclass = $class.padStart( $len, ".");

                    const Swiper = elementorFrontend.utils.swiper;

                    //new Swiper( $($sclass),$settings );
                    new Swiper( $($sclass), this._getSwiperSettings() );

                    if( $this._isBool( $settings.pauseOnHover ) === true ) {
                        $($sclass).hover(function () {
                            (this).swiper.autoplay.stop();
                        }, function () {
                            (this).swiper.autoplay.start();
                        });
                    }
                }
            },

            _getSwiperSettings() {
                const elementSettings = this.$element.data('settings') || {};
                const elementID       = this.getID();

                const swiperOptions   = {
                    autoHeight                : true,
                    handleElementorBreakpoints: true
                };

                // Arrow
                if( elementSettings.arrows == 'yes' ) {
                    swiperOptions.navigation = {
                        nextEl: '.kfw-js-swiper-' + elementID + '-nav-next',
                        prevEl: '.kfw-js-swiper-' + elementID + '-nav-prev',
                    };

                    swiperOptions.arrowPosition = elementSettings.arrow_position;

                    if( elementSettings.mobile_arrows == 'yes' ) {
                        swiperOptions.hideArrowsOnMobile = true;
                    } else {
                        swiperOptions.hideArrowsOnMobile = false;
                    }
                }

                // Dots
                if( elementSettings.dots == 'yes' ) {
                    swiperOptions.pagination = {
                        type: 'bullets',
                        clickable: true,
                        el: '.kfw-js-swiper-'+ elementID +'-pagination',
                    };
                }

                const slidesToShow           = +elementSettings.cols || 3,
                      elementorBreakpoints   = elementorFrontend.config.responsive.activeBreakpoints,
                      defaultSlidesToShowMap = {
                        mobile: 1,
                        tablet: 2,
                    };

                swiperOptions.slidesPerView = slidesToShow;
                swiperOptions.loop          = 'yes' === elementSettings.loop;
                swiperOptions.slidesPerGroup = +elementSettings.slides_to_scroll || 1;

                if (elementSettings.col_gap) {
                    swiperOptions.spaceBetween = this._getSpaceBetween();
                } else {
                    swiperOptions.spaceBetween = 20;
                }

                if( elementSettings.autoplay == 'yes' ) {

                    if( elementSettings.pause == 'yes' ) {
                        swiperOptions.pauseOnHover = 'true';
                    } else {
                        swiperOptions.pauseOnHover = 'false';
                    }

                    swiperOptions.autoplay = {
                        delay: elementSettings.autoplay_speed.size,
                        disableOnInteraction:'yes' === elementSettings.pause_on_interaction
                    };
                } else {
                    swiperOptions.pauseOnHover = 'false';
                }

                // BreakPoints
                    swiperOptions.breakpoints = {};
                    let lastBreakpointSlidesToShowValue = slidesToShow;

                    Object.keys(elementorBreakpoints).reverse().forEach(breakpointName => {
                        const defaultSlidesToShow = defaultSlidesToShowMap[breakpointName] ? defaultSlidesToShowMap[breakpointName] : lastBreakpointSlidesToShowValue;
                        swiperOptions.breakpoints[elementorBreakpoints[breakpointName].value] = {
                            device:breakpointName,
                            slidesPerView: +elementSettings['cols_' + breakpointName] || defaultSlidesToShow,
                            slidesPerGroup:+elementSettings['slide_to_scroll_' + breakpointName] || 1
                        };

                        if (elementSettings.col_gap) {
                            swiperOptions.breakpoints[elementorBreakpoints[breakpointName].value].spaceBetween = this._getSpaceBetween(breakpointName);
                        }

                        lastBreakpointSlidesToShowValue = +elementSettings['cols_' + breakpointName] || defaultSlidesToShow;
                    });

                return swiperOptions;
            },

            _getSpaceBetween: function() {
                let device = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                const elementSettings        = this.$element.data('settings') || {};

                return elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, 'col_gap', 'size', device) || 0;
            },

            _isBool($arg ) {
                switch( $arg ) {
                    case true:
                    case "true":
                    case "TRUE":
                    case 1:
                    case "1":
                    case "on":
                    case "ON":
                    case "yes":
                    case "YES":
                    case "right":
                    case "RIGHT":
                        return true;

                    default:
                        return false;
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-cpt-team-member-carousel', KFW_CPT_Team_Member_Carousel );
    });
})( jQuery, window.elementorFrontend );
