(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler     = elementorModules.frontend.handlers.Base,
            KFW_Custom_Heading;

        KFW_Custom_Heading = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-custom-heading-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this   = this,
                    $isEdit = $this.isEdit ? true : false;

                if( !$this._isMobile() ) {
                    if( $('body').hasClass('kinfw-has-site-loader') ) {
                        $('body').on("kinfw-loaded", function( $body, $ele ){
                            $this._execute();
                        });
                    } else {
                        $this._execute();
                    }
                }
            },

            _execute() {
                let $id   = this.getID(),
                    $main = this.elements.$main;

                const {
                    animate:$animate,
                    animation:$animation,
                    tween:$tween,
                    ease: $ease
                } = $main.data('settings');

                if( $animate && $animation !== 'none' ) {
                    gsap.config({
                        nullTargetWarn: false,
                        trialWarn: false
                    });

                    gsap.registerPlugin(ScrollTrigger, SplitText, CSSRulePlugin);

                    /**
                     * Title
                     */
                    let $headingTag = $('.kfw-ele-widget-custom-heading-title', $main );

                    if( $headingTag.length ) {

                        gsap.set($headingTag, { perspective:400 });

                        let $splitTxt = new SplitText( $headingTag, {
                            tag       : 'kfw-gsap-ele',
                            type      : "lines,words,chars",
                            charsClass: "kfw-chars kfw-chars-++",
                            linesClass: "kfw-lines kfw-lines-++",
                            wordsClass: "kfw-words kfw-words-++",
                        });

                        let $target = null;
                        if( 'lines' === $tween ) {
                            $target = $splitTxt.lines;
                        }else if( 'words' === $tween ) {
                            $target = $splitTxt.words;
                        }else if( 'chars' === $tween ) {
                            $target = $splitTxt.chars;
                        }

                        if( typeof($target) !== null ) {

                            if( 'style-1' === $animation) {
                                gsap.set($target, { opacity:0,});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 80%",
                                        end: 'bottom 60%',
                                    },
                                    opacity:1,
                                    duration:1.5,
                                    stagger:0.05,
                                    ease:'back',
                                });
                            } else if( 'style-2' === $animation ) {
                                let $stagger = ( $tween === 'words' || $tween === 'line') ? '0.05' : '0.01',
                                    $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set( $target, {opacity:0, x:50});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    x:0,
                                    duration:1,
                                    stagger:$stagger,
                                    ease:$easing,
                                });
                            } else if( 'style-3' === $animation ) {
                                let $stagger = ( $tween === 'words' || $tween === 'line') ? '0.05' : '0.02',
                                    $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set( $target, {opacity:0, y:-100});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    y:0,
                                    duration:1,
                                    stagger:$stagger,
                                    ease:$easing,
                                });
                            } else if( 'style-4' === $animation ) {
                                let $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;
                                gsap.from( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    y:80,
                                    opacity:0,
                                    duration:1,
                                    stagger:.01,
                                    ease:$easing,
                                });
                            } else if( 'style-5' === $animation ) {
                                let $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set($target, { opacity:0, rotateY:-90, });

                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    rotateY:0,
                                    duration:1,
                                    stagger:.02,
                                    ease:$easing
                                });
                            } else if( 'style-6' === $animation ) {
                                let $dot  = $('.kfw-anim-dot', $main ),
                                    $line = $('.kfw-anim-line', $main );

                                gsap.set( $dot,{opacity:0,y:-100});
                                gsap.set( $line, {opacity:0,scale:0});

                                let $tl = gsap.timeline({
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                });

                                $tl
                                    .to($dot,{opacity:1, y:0, ease:"back"})
                                    .to($line,{duration:.5, opacity:1, scale:1, transformOrigin:'left'}, '-=.5');

                            } else if( 'style-7' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-7 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    top:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-8' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-8 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    right:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-9' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-9 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 50%",
                                        toggleActions:"play none none reverse",
                                    },
                                    bottom:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-10' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-10 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    left:'-110%',
                                    duration:.5
                                });
                            }
                        }

                    }

                    /**
                     * Sub Title
                     */
                    let $subHeadingTag = $('.kfw-ele-widget-custom-heading-sub-title', $main );

                    if( $subHeadingTag.length ) {

                        gsap.set($subHeadingTag, { perspective:400 });

                        let $splitTxt = new SplitText( $subHeadingTag, {
                            tag       : 'kfw-gsap-ele',
                            type      : "lines,words,chars",
                            charsClass: "kfw-chars kfw-chars-++",
                            linesClass: "kfw-lines kfw-lines-++",
                            wordsClass: "kfw-words kfw-words-++",
                        });

                        let $target = null;
                        if( 'lines' === $tween ) {
                            $target = $splitTxt.lines;
                        }else if( 'words' === $tween ) {
                            $target = $splitTxt.words;
                        }else if( 'chars' === $tween ) {
                            $target = $splitTxt.chars;
                        }

                        if( typeof($target) !== null ) {

                            if( 'style-1' === $animation) {
                                gsap.set($target, { opacity:0,});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 80%",
                                        end: 'bottom 60%',
                                    },
                                    opacity:1,
                                    duration:1.5,
                                    stagger:0.05,
                                    ease:'back',
                                });
                            } else if( 'style-2' === $animation ) {
                                let $stagger = ( $tween === 'words' || $tween === 'line') ? '0.05' : '0.01',
                                    $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set( $target, {opacity:0, x:50});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    x:0,
                                    duration:1,
                                    stagger:$stagger,
                                    ease:$easing,
                                });
                            } else if( 'style-3' === $animation ) {
                                let $stagger = ( $tween === 'words' || $tween === 'line') ? '0.05' : '0.02',
                                    $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set( $target, {opacity:0, y:-100});
                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    y:0,
                                    duration:1,
                                    stagger:$stagger,
                                    ease:$easing,
                                });
                            } else if( 'style-4' === $animation ) {
                                let $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;
                                gsap.from( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    y:80,
                                    opacity:0,
                                    duration:1,
                                    stagger:.01,
                                    ease:$easing,
                                });
                            } else if( 'style-5' === $animation ) {
                                let $easing  = ( typeof( $ease ) === 'undefined' ) ? 'bounce' : $ease;

                                gsap.set($target, { opacity:0, rotateY:-90, });

                                gsap.to( $target, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                    opacity:1,
                                    rotateY:0,
                                    duration:1,
                                    stagger:.02,
                                    ease:$easing
                                });
                            } else if( 'style-6' === $animation ) {
                                let $dot  = $('.kfw-anim-dot', $main ),
                                    $line = $('.kfw-anim-line', $main );

                                gsap.set( $dot,{opacity:0,y:-100});
                                gsap.set( $line, {opacity:0,scale:0});

                                let $tl = gsap.timeline({
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                    },
                                });

                                $tl
                                    .to($dot,{opacity:1, y:0, ease:"back"})
                                    .to($line,{duration:.5, opacity:1, scale:1, transformOrigin:'left'}, '-=.5');

                            } else if( 'style-7' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-7 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    top:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-8' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-8 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    right:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-9' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-9 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 50%",
                                        toggleActions:"play none none reverse",
                                    },
                                    bottom:'-110%',
                                    duration:.5
                                });
                            } else if( 'style-10' === $animation ) {
                                var $rule = CSSRulePlugin.getRule(".kfw-custom-heading-anim-style-10 .kfw-words:before");

                                gsap.to($rule, {
                                    scrollTrigger:{
                                        trigger: $main,
                                        start: "top 90%",
                                        toggleActions:"play none none reverse",
                                    },
                                    left:'-110%',
                                    duration:.5
                                });
                            }
                        }
                    }

                }
            },

            _isMobile() {
                let isAndroid    = navigator.userAgent.match(/Android/i),
                    isBlackBerry = navigator.userAgent.match(/BlackBerry/i),
                    isIOS        = navigator.userAgent.match(/iPhone|iPad|iPod/i),
                    isOpera      = navigator.userAgent.match(/Opera Mini/i),
                    isWindows    = navigator.userAgent.match(/IEMobile|Windows Phone/i);

                return (
                    isAndroid ||
                    isBlackBerry ||
                    isIOS ||
                    isOpera ||
                    isWindows
                );
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-custom-heading', KFW_Custom_Heading );
    });
})( jQuery, window.elementorFrontend );