(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler     = elementorModules.frontend.handlers.Base,
            KFW_Custom_Text;

        KFW_Custom_Text = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-custom-text-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this   = this,
                    $isEdit = $this.isEdit ? true : false;

                $this._execute();
            },

            _execute() {
                let $this     = this,
                    $id       = this.getID(),
                    //$settings = this.getSettings().$element.data("settings"),
                    $main     = this.elements.$main;

                let $settings = $main.data('settings') || {};

                if( typeof( $settings ) !== 'undefined' && $this._isBool( $settings.anim_title ) === true ) {
                    gsap.config({
                        nullTargetWarn: false,
                        trialWarn: false
                    });

                    gsap.registerPlugin(ScrollTrigger, SplitText);

                    let $items = $('.elementor-repeater-item', $main );
                    if( $items.length ) {

                        let $splitTxt;

                        if( $this._isBool( $settings.split ) === true ) {
                            $splitTxt = new SplitText( $items, {
                                tag       : 'kfw-gsap-ele',
                                type      : "words",
                                charsClass: "kfw-chars kfw-chars-++",
                                wordsClass: "kfw-words kfw-words-++",
                            });
                        }

                        if( 'style-1' === $settings.anim_type ) {
                            let $target = $splitTxt.words;
                            gsap.set($target, { opacity:0,});
                            gsap.to( $target, {
                                scrollTrigger:{
                                    trigger: $main,
                                    start: "top 80%",
                                    end: 'bottom 60%',
                                },
                                opacity:1,
                                duration:1.5,
                                stagger:0.05,
                                ease:'back',
                            });
                        } else if( 'style-2' === $settings.anim_type ) {
                            let $target  = $splitTxt.words,
                                $stagger = '0.05',
                                $easing  = 'back'; //bounce, back

                            gsap.set( $target, {opacity:0, x:50});
                            gsap.to( $target, {
                                scrollTrigger:{
                                    trigger: $main,
                                    start: "top 90%",
                                },
                                opacity:1,
                                x:0,
                                duration:1,
                                stagger:$stagger,
                                ease:$easing,
                            });
                        } else if( 'style-3' === $settings.anim_type ) {
                            let $target  = $splitTxt.words,
                                $stagger = '0.05',
                                $easing  = 'back'; //bounce, back

                            gsap.set( $target, {opacity:0, y:-100});
                            gsap.to( $target, {
                                scrollTrigger:{
                                    trigger: $main,
                                    start: "top 90%",
                                },
                                opacity:1,
                                y:0,
                                duration:1,
                                stagger:$stagger,
                                ease:$easing,
                            });

                        } else if( 'style-4' === $settings.anim_type ) {
                            let $target  = $splitTxt.words,
                                $stagger = '0.01',
                                $easing  = 'back'; //bounce, back

                            gsap.from( $target, {
                                scrollTrigger:{
                                    trigger: $main,
                                    start: "top 90%",
                                },
                                y:80,
                                opacity:0,
                                duration:1,
                                stagger:.01,
                                ease:$easing,
                            });
                        } else if( 'style-5' === $settings.anim_type ) {
                            let $target  = $splitTxt.words,
                                $stagger = '0.02',
                                $easing  = 'back'; //bounce, back

                            gsap.set($target, { opacity:0, rotateY:-90, });

                            gsap.to( $target, {
                                scrollTrigger:{
                                    trigger: $main,
                                    start: "top 90%",
                                },
                                opacity:1,
                                rotateY:0,
                                duration:1,
                                stagger:$stagger,
                                ease:$easing
                            });
                        } else if( 'style-6' === $settings.anim_type ) {
                            $items.each(function(){
                                let target = $(this);
                                gsap.to(target, {
                                    backgroundPositionX: 0,
                                    ease: "none",
                                    scrollTrigger: {
                                        trigger: target,
                                        scrub: 1.5,
                                        start: "top center",
                                        end: "bottom center"
                                    }
                                });
                            });
                        }
                    }
                }
            },

            _isBool($arg ) {
                switch( $arg ) {
                    case true:
                    case "true":
                    case "TRUE":
                    case 1:
                    case "1":
                    case "on":
                    case "ON":
                    case "yes":
                    case "YES":
                    case "right":
                    case "RIGHT":
                        return true;

                    default:
                        return false;
                }
            },


            _isMobile() {
                let isAndroid    = navigator.userAgent.match(/Android/i),
                    isBlackBerry = navigator.userAgent.match(/BlackBerry/i),
                    isIOS        = navigator.userAgent.match(/iPhone|iPad|iPod/i),
                    isOpera      = navigator.userAgent.match(/Opera Mini/i),
                    isWindows    = navigator.userAgent.match(/IEMobile|Windows Phone/i);

                return (
                    isAndroid ||
                    isBlackBerry ||
                    isIOS ||
                    isOpera ||
                    isWindows
                );
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-custom-text', KFW_Custom_Text );
    });
})( jQuery, window.elementorFrontend );
