(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){

        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Flip_Box  = '';

        KFW_Flip_Box = moduleHandler.extend({
            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                var $this = this;
                var $main = $this.$element;

                setTimeout(function(){
                    $main.removeClass('kfw-ele-transition-disabled');
                }, 600);

                $('body').on("click",".kfw-ele-widget-flip-box-clickable",function(e){
                    e.preventDefault();
                    var $ele = $(this),
                        $id  = "#kfw-ele-widget-flip-box-clickable-" + $this.getID();

                    if( $($id).length === 0 ) {
                        $('body').append(
                            $(document.createElement('a')).prop({
                                id       : $id.replace("#",""),
                                href     : $ele.attr('data-link'),
                                target   : $ele.attr('data-target') ? '_blank': '_self',
                                class    : 'hidden',
                                innerText: $id.replace("#",""),
                            })
                        );
                    }

                    $($id)[0].click();
                });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-flip-box-minimal', KFW_Flip_Box );
        elementorFrontend.elementsHandler.attachHandler( 'kfw-flip-box-cover', KFW_Flip_Box );
        elementorFrontend.elementsHandler.attachHandler( 'kfw-flip-box-cube', KFW_Flip_Box );
    });
})( jQuery, window.elementorFrontend );