(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Horiz_Scroll_Ele;

        KFW_Horiz_Scroll_Ele = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-horiz-scroll-ele-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                this._execute();
            },

            _execute() {
                let $id              = this.getID();
                let $scrollContainer = document.querySelector("#kfw-ele-widget-horiz-scroll-ele-" + $id);

                // Calculate total scroll width
                let $totalWidth = $scrollContainer.scrollWidth - document.querySelector('#kfw-ele-widget-horiz-scroll-ele-trigger-' + $id).offsetWidth;
                //const $totalWidth = $scrollContainer.scrollWidth - window.innerWidth;

                gsap.registerPlugin(ScrollTrigger);
                gsap.config({
                    nullTargetWarn: false,
                    trialWarn     : false
                });

                gsap.to($scrollContainer, {
                    x            : -$totalWidth,
                    ease         : "none",
                    scrollTrigger: {
                        trigger: '#kfw-ele-widget-horiz-scroll-ele-trigger-' + $id,
                        pin    : true,
                        scrub  : true,
                        start  : "top top",
                        end    : () => "+=" + $totalWidth
                    }
                });
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-horizontal-scroll-element', KFW_Horiz_Scroll_Ele );
    });
})( jQuery, window.elementorFrontend );
