(function($){
    $.fn.KinForceTwentyTwenty = function(options) {

        var options = $.extend({
            default_offset_pct         : 0.5,
            orientation                : 'horizontal',
            show_before_label          : true,
            before_label               : 'Before',
            before_label_position      : [ 'kfw-ele-image-compare-before-label-horizontal-alignment-left',
                'kfw-ele-image-compare-before-label-vertical-alignment-middle' ],
            show_after_label           : true,
            after_label                : 'After',
            after_label_position       : [ 'kfw-ele-image-compare-after-label-horizontal-alignment-left',
                'kfw-ele-image-compare-after-label-vertical-alignment-middle'],
            no_overlay                 : false,
            move_slider_on_hover       : false,
            move_with_handle_only      : true,
            click_to_move              : false,
            show_drag_handle_separator : true,
            arrow : 'chevron'
        }, options);

        return this.each(function() {

            var sliderPct         = options.default_offset_pct;
            var container         = $(this);
            var sliderOrientation = options.orientation;
            var arrow             = options.arrow;

            container.wrap("<div class='kfw-ele-image-compare-wrapper kfw-ele-image-compare-" + sliderOrientation + "'></div>");

            if(!options.no_overlay) {
                container.append("<div class='kfw-ele-image-compare-overlay'></div>");
                var overlay = container.find(".kfw-ele-image-compare-overlay");

                if( options.show_before_label ) {
                    var classes = options.before_label_position.join(" ");
                    overlay.append("<div class='kfw-ele-image-compare-before-label " + classes + "'> <span>" + options.before_label + "</span> </div>");
                }

                if( options.show_after_label ) {
                    var classes = options.after_label_position.join(" ");
                    overlay.append("<div class='kfw-ele-image-compare-after-label "+ classes + "'> <span>" + options.after_label + "</span> </div>");
                }
            } else {
                container.append("<div class='kfw-ele-image-compare-overlay kfw-ele-hidden'></div>");
            }

            var beforeImg = container.find("img:first");
            var afterImg  = container.find("img:last");

            if( options.show_drag_handle_separator ) {
                container.append("<div class='kfw-ele-image-compare-handle'></div>");
            } else {
                container.append("<div class='kfw-ele-image-compare-handle kfw-ele-image-compare-separator-hidden'></div>");
            }

            var slider     = container.find(".kfw-ele-image-compare-handle"),
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-chevron-left",
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-chevron-right";

            if( arrow == "angle" ){
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-angle-left",
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-angle-right";
            }else if( arrow == "angle-double" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-angles-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-angles-right";
            }else if( arrow == "arrow" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-arrow-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-arrow-right";
            }else if( arrow == "arrow-circle" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-circle-arrow-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-circle-arrow-right";
            }else if( arrow == "caret" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-caret-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-caret-right";
            }else if( arrow == "caret-square-o" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-square-caret-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-square-caret-right";
            }else if( arrow == "chevron" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-chevron-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-chevron-right";
            }else if( arrow == "chevron-circle" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-circle-chevron-left";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-circle-chevron-right";
            }else if( arrow == "long-arrow" ) {
                beforeIcon = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-arrow-left-long";
                afterIcon  = "kfw-elementor-widget-image-comparision-icon kfw-elementor-widget-image-comparision-icon-arrow-right-long";
            }

            if( sliderOrientation == "vertical" ) {
                beforeIcon = beforeIcon.replace("left","up");
                afterIcon = afterIcon.replace("right","down");
            }

            slider.append("<span class='kfw-ele-image-compare-arrow'> <i class='" + beforeIcon + "'></i> </span>");
            slider.append("<span class='kfw-ele-image-compare-arrow'> <i class='" + afterIcon + "'></i> </span>");

            beforeImg.addClass("kfw-ele-image-compare-before");
            afterImg.addClass("kfw-ele-image-compare-after");

            var calcOffset = function(dimensionPct) {
                var w = beforeImg.width();
                var h = beforeImg.height();

                return {
                    w: w+"px",
                    h: h+"px",
                    cw: (dimensionPct*w)+"px",
                    ch: (dimensionPct*h)+"px"
                };
            };

            var adjustContainer = function(offset) {
                if (sliderOrientation === 'vertical') {
                    beforeImg.css("clip", "rect(0,"+offset.w+","+offset.ch+",0)");
                    afterImg.css("clip", "rect("+offset.ch+","+offset.w+","+offset.h+",0)");
                } else {
                    beforeImg.css("clip", "rect(0,"+offset.cw+","+offset.h+",0)");
                    afterImg.css("clip", "rect(0,"+offset.w+","+offset.h+","+offset.cw+")");
                }
                container.css("height", offset.h);
            };

            var adjustSlider = function(pct) {
                var offset = calcOffset(pct);
                slider.css((sliderOrientation==="vertical") ? "top" : "left", (sliderOrientation==="vertical") ? offset.ch : offset.cw);
                adjustContainer(offset);
                adjustLabelClasses();
            };

            var adjustLabelClasses = function() {

                var afterLabel  = $(container).find(".kfw-ele-image-compare-after-label"),
                    beforeLabel = $(container).find(".kfw-ele-image-compare-before-label");

                if( afterLabel.length == 1 || beforeLabel.length == 1 ) {

                    if( sliderOrientation === "horizontal" ) {
                        var beforeLabelOffset = ( 'undefined' !== typeof ( beforeLabel.css("left") ) ) ? parseInt(beforeLabel.css("left").replace(/px/,'')) : '',
                            beforeLabelWidth  = parseInt(beforeLabel.outerWidth()),
                            afterLabelOffset  = ( 'undefined' !== typeof ( afterLabel.css("left") ) ) ? parseInt(afterLabel.css("left").replace(/px/,'')): '',
                            sliderOffset      = parseInt(slider.css("left").replace(/px/,''));

                        if( sliderOffset < ( beforeLabelOffset + beforeLabelWidth ) ) {
                            beforeLabel.addClass("kfw-ele-hide-label");
                        } else {
                            beforeLabel.removeClass("kfw-ele-hide-label");
                        }

                        if( sliderOffset > parseInt( afterLabelOffset ) ) {
                            afterLabel.addClass("kfw-ele-hide-label");
                        } else {
                            afterLabel.removeClass("kfw-ele-hide-label");
                        }
                    } else {

                        var beforeLabelOffset = parseInt(beforeLabel.css("top").replace(/px/,'')),
                            beforeLabelHeight = parseInt(beforeLabel.outerHeight(true)),
                            afterLabelOffset  = parseInt(afterLabel.css("top").replace(/px/,'')),
                            afterLabelHeight  = parseInt(afterLabel.outerHeight(true)),
                            sliderOffset      = parseInt(slider.css("top").replace(/px/,''));

                        if( sliderOffset < ( beforeLabelOffset + beforeLabelHeight ) ) {
                            beforeLabel.addClass("kfw-ele-hide-label");
                        } else {
                            beforeLabel.removeClass("kfw-ele-hide-label");
                        }

                        if( sliderOffset > afterLabelOffset && !( afterLabelOffset < 0 ) ) {
                            afterLabel.addClass("kfw-ele-hide-label");
                        } else {
                            afterLabel.removeClass("kfw-ele-hide-label");
                        }
                    }
                }
            };

            // Return the number specified or the min/max number if it outside the range given.
            var minMaxNumber = function(num, min, max) {
                return Math.max(min, Math.min(max, num));
            };

            // Calculate the slider percentage based on the position.
            var getSliderPercentage = function(positionX, positionY) {
                var sliderPercentage = (sliderOrientation === 'vertical') ? (positionY-offsetY)/imgHeight : (positionX-offsetX)/imgWidth;
                return minMaxNumber(sliderPercentage, 0, 1);
            };

            $(window).on("resize.KinForceTwentyTwenty", function(e) {
                adjustSlider(sliderPct);
            });

            var offsetX   = 0;
            var offsetY   = 0;
            var imgWidth  = 0;
            var imgHeight = 0;

            var onMoveStart = function(e) {

                if (((e.distX > e.distY && e.distX < -e.distY) || (e.distX < e.distY && e.distX > -e.distY)) && sliderOrientation !== 'vertical') {
                    e.preventDefault();
                } else if (((e.distX < e.distY && e.distX < -e.distY) || (e.distX > e.distY && e.distX > -e.distY)) && sliderOrientation === 'vertical') {
                    e.preventDefault();
                }

                container.addClass("active");
                offsetX   = container.offset().left;
                offsetY   = container.offset().top;
                imgWidth  = beforeImg.width();
                imgHeight = beforeImg.height();
            };

            var onMove = function(e) {
                if (container.hasClass("active")) {
                    sliderPct = getSliderPercentage(e.pageX, e.pageY);
                    adjustSlider(sliderPct);
                }
            };

            var onMoveEnd = function() {
                container.removeClass("active");
            };

            var moveTarget = options.move_with_handle_only ? slider : container;

            moveTarget.on("movestart",onMoveStart);
            moveTarget.on("move",onMove);
            moveTarget.on("moveend",onMoveEnd);

            if (options.move_slider_on_hover) {
                container.on("mouseenter", onMoveStart);
                container.on("mousemove", onMove);
                container.on("mouseleave", onMoveEnd);
            }

            slider.on("touchmove", function(e) {
                e.preventDefault();
            });

            container.find("img").on("mousedown", function(event) {
                event.preventDefault();
            });

            if (options.click_to_move) {

                container.on('click', function(e) {
                    offsetX   = container.offset().left;
                    offsetY   = container.offset().top;
                    imgWidth  = beforeImg.width();
                    imgHeight = beforeImg.height();
                    sliderPct = getSliderPercentage(e.pageX, e.pageY);
                    adjustSlider(sliderPct);
                });
            }

            $(window).trigger("resize.KinForceTwentyTwenty");
        });
    };
})(jQuery);