(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler       = elementorModules.frontend.handlers.Base,
            KFW_Lottie_Icon_Box;

        KFW_Lottie_Icon_Box = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        lottieContainer : '#kfw-elementor-lottie-wrap-' + this.getID(),
                    }
                }
            },

            getDefaultElements() {
                const selectors = this.getSettings( 'selectors' );
                return {
                    $lottieContainer: this.$element.find( selectors.lottieContainer ),
                };
            },

            bindEvents: function () {
                this._execute();
            },

            /**
             * New elementor 3.24.0 +
             * Replaced waypoints.js library with the native Intersection Observer API
             * But 'scroll' === $settings.view  has some issues - we removed it
             */
            _execute: function() {
                if( this.elements.$lottieContainer.length ) {
                    var $this     = this,
                        $wrapper  = this.elements.$lottieContainer,
                        $settings = $wrapper.data('settings') || {};

                    var $lottieContainer = document.getElementById($($wrapper).attr('id'));
                    this._render( this, $lottieContainer, $settings );
                }
            },

            /**
             * Older Elementor 3.20 uses waypoint script
             */
            _executeOld: function() {
                if( this.elements.$lottieContainer.length ) {
                    var $this     = this,
                        $wrapper  = this.elements.$lottieContainer,
                        $settings = $wrapper.data('settings') || {};

                    var $lottieContainer = document.getElementById($($wrapper).attr('id'));

                    if( 'scroll' === $settings.view ) {
                        elementorFrontend.waypoint( this.elements.$lottieContainer, function(){
                            $this._render( $lottieContainer, $settings );
                        },{ offset: '90%' });
                    } else {
                        this._render( this, $lottieContainer, $settings );
                    }
                }
            },
            _render: function( $this, $lottieContainer, $settings ) {
                var $path = $settings.lottie;

                if( 'custom' === $settings.type ) {
                    var $blob = new Blob([$settings.code], { type: 'application/javascript' });
                        $path = URL.createObjectURL( $blob );
                }

                var $lottieAnimation = lottie.loadAnimation({
                    container: $lottieContainer,
                    path     : $path,
                    renderer : $settings.render,
                    loop     : $settings.loop,
                    autoplay : ( 'autoplay' === $settings.trigger ),
                });

                $lottieAnimation.setSpeed($settings.speed);

                $lottieAnimation.addEventListener('DOMLoaded',function(e){
                    var $points = $this._getFrameNo({
                        firstFrame : $lottieAnimation.firstFrame,
                        totalFrames: $lottieAnimation.totalFrames,
                        startPoint : $settings.start,
                        endPoint   : $settings.end
                    });
                    $lottieAnimation.playSegments([ $points.startPoint, $points.endPoint ], true );
                });

                if( $settings.trigger === 'default' || $settings.trigger === 'none' ) {
                    $lottieAnimation.goToAndStop(0);
                } else if( $settings.trigger === 'autoplay' ) {
                    $lottieAnimation.goToAndStop(0);
                } else if( $settings.trigger === 'click' ) {
                    $lottieContainer.addEventListener('click',function(){
                        $lottieAnimation.goToAndPlay(0);
                    });
                } else if( $settings.trigger === 'hover' ) {
                    $lottieContainer.addEventListener('mouseenter',function(){
                        $lottieAnimation.goToAndPlay(0);
                    });
                }
            },
            _getFrameNo( $options ) {
                var $startPointPercent = Math.min(100, Math.max(0, $options.startPoint));
                var $endPointPercent   = Math.min(100, Math.max(0, $options.endPoint));

                $startPoint = $options.firstFrame + ( $options.totalFrames - $options.firstFrame ) * $startPointPercent / 100;
                $endPoint   = $options.firstFrame + ( $options.totalFrames - $options.firstFrame ) * $endPointPercent / 100;

                return {
                    startPoint: $startPoint,
                    endPoint: $endPoint,
                };
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-lottie-icon-box', KFW_Lottie_Icon_Box );
    });
})( jQuery, window.elementorFrontend );