(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_PT_Clean;

        KFW_PT_Clean = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        numberEle            : '.kfw-ele-pricing-table-price-numeric',
                        fractionalNumberEle  : '.kfw-ele-pricing-table-price-fractional',
                        numberBGEle          : '.kfw-ele-pricing-table-bg-price-numeric',
                        fractionalNumberBGEle: '.kfw-ele-pricing-table-bg-price-fractional',
                    }
                }
            },

            getDefaultElements() {
                const selectors = this.getSettings( 'selectors' );
                return {
                    $numberEle            : this.$element.find( selectors.numberEle ),
                    $fractionalNumberEle  : this.$element.find( selectors.fractionalNumberEle ),
                    $numberBGEle          : this.$element.find( selectors.numberBGEle ),
                    $fractionalNumberBGEle: this.$element.find( selectors.fractionalNumberBGEle ),
                };
            },

            bindEvents: function () {
                this._execute();
            },

            _execute: function() {
                if( this.elements.$numberEle.length ) {

                    this.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                        callback: ( event ) => {
                            if ( event.isInViewport ) {
                                this.intersectionObserver.unobserve( this.elements.$numberEle[ 0 ] );

                                this.elements.$numberEle.numerator({
                                    duration: 1000,
                                    toValue : this.elements.$numberEle.data('toval'),
                                    rounding: this.elements.$numberEle.data('round'),
                                });
                            }
                        },
                    });

                    this.intersectionObserver.observe( this.elements.$numberEle[ 0 ] );
                }

                if( this.elements.$fractionalNumberEle.length ) {
                    this.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                        callback: ( event ) => {
                            if ( event.isInViewport ) {
                                this.intersectionObserver.unobserve( this.elements.$fractionalNumberEle[ 0 ] );
                                this.elements.$fractionalNumberEle.numerator({
                                    duration: 1000,
                                    toValue : this.elements.$fractionalNumberEle.data('toval')
                                });
                            }
                        },
                    });

                    this.intersectionObserver.observe( this.elements.$fractionalNumberEle[ 0 ] );
                }

                if( this.elements.$numberBGEle.length ) {

                    this.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                        callback: ( event ) => {
                            if ( event.isInViewport ) {
                                this.intersectionObserver.unobserve( this.elements.$numberBGEle[ 0 ] );

                                this.elements.$numberBGEle.numerator({
                                    duration: 1000,
                                    toValue : this.elements.$numberBGEle.data('toval'),
                                    rounding: this.elements.$numberBGEle.data('round'),
                                });
                            }
                        },
                    });

                    this.intersectionObserver.observe( this.elements.$numberBGEle[ 0 ] );
                }

                if( this.elements.$fractionalNumberBGEle.length ) {
                    this.intersectionObserver = elementorModules.utils.Scroll.scrollObserver({
                        callback: ( event ) => {
                            if ( event.isInViewport ) {
                                this.intersectionObserver.unobserve( this.elements.$fractionalNumberBGEle[ 0 ] );
                                this.elements.$fractionalNumberBGEle.numerator({
                                    duration: 1000,
                                    toValue : this.elements.$fractionalNumberBGEle.data('toval')
                                });
                            }
                        },
                    });

                    this.intersectionObserver.observe( this.elements.$fractionalNumberBGEle[ 0 ] );
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-pricing-table-clean', KFW_PT_Clean );
    });
})( jQuery, window.elementorFrontend );