(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler          = elementorModules.frontend.handlers.Base,
            KFW_Progressbar_Circle;

        KFW_Progressbar_Circle = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        wrapper: '.kfw-ele-widget-pbar-circle-wrapper'
                    }
                }
            },

            getDefaultElements() {
                const { wrapper } = this.getSettings( 'selectors' );

                return {
                    $wrapper : this.$element.find( wrapper ),
                    $bar: this.findElement('.kfw-ele-widget-pbar-circle'),
                }
            },

            bindEvents: function () {
                this._execute();
            },

            /**
             * New elementor 3.24.0 +
             * Replaced waypoints.js library with the native Intersection Observer API
             */
            _execute: function() {
                if( !this.elements.$bar.length ) {
                    return;
                }

                const observer = this._createObserver();
                observer.observe( this.elements.$bar[0] );
            },

            _createObserver() {

                var $mainSettings    = this.getElementSettings();
                var $wrapperSettings = this.elements.$bar.data('settings') || {};

                const options = {
                    threshold : 0,
                };

                return new IntersectionObserver( ( entries ) => {
                    entries.forEach( ( entry ) => {
                        if ( entry.isIntersecting ) {
                            var $this = this.elements.$bar;
                            $this.asPieProgress({
                                namespace: 'pieProgress',
                                classes: {
                                    svg    : 'kfw-ele-widget-pbar-circle-svg',
                                    number : 'kfw-ele-widget-pbar-circle-number',
                                    content: 'kfw-ele-widget-pbar-circle-content',
                                },
                                speed:$wrapperSettings.speed,
                                easing:$wrapperSettings.easing,
                                min:$wrapperSettings.min,
                                max:$wrapperSettings.max,
                                goal:$wrapperSettings.goal,
                                barsize:$wrapperSettings.barsize,
                                barcolor:$wrapperSettings.barcolor,
                                trackcolor:$wrapperSettings.trackcolor,
                                numberCallback(n) {
                                    if( $mainSettings.bar_val_type === 'absolute' &&
                                        ( !$mainSettings.hasOwnProperty('show') || $mainSettings.show === '' ) ) {
                                        return n;
                                    } else {
                                        const percentage = Math.round(this.getPercentage(n));
                                        return percentage;
                                    }
                                }
                            });

                            $this.asPieProgress('start');
                        }
                    });
                }, options );
            },

            /**
             * Older Elementor 3.20 uses waypoint script
             */
            _executeOld: function() {
                if( !this.elements.$bar.length ) {
                    return;
                }

                var $mainSettings    = this.getElementSettings();
                var $wrapperSettings = this.elements.$bar.data('settings') || {};

                elementorFrontend.waypoint( this.elements.$bar, function(){
                    var $this = $(this);

                    $this.asPieProgress({
                        namespace: 'pieProgress',
                        classes: {
                            svg    : 'kfw-ele-widget-pbar-circle-svg',
                            number : 'kfw-ele-widget-pbar-circle-number',
                            content: 'kfw-ele-widget-pbar-circle-content',
                        },
                        min:$wrapperSettings.min,
                        max:$wrapperSettings.max,
                        goal:$wrapperSettings.goal,
                        barsize:$wrapperSettings.barsize,
                        barcolor:$wrapperSettings.barcolor,
                        trackcolor:$wrapperSettings.trackcolor,
                        numberCallback(n) {
                            if( $mainSettings.bar_val_type === 'absolute' &&
                                ( !$mainSettings.hasOwnProperty('show') || $mainSettings.show === '' ) ) {
                                return n;
                            } else {
                                const percentage = Math.round(this.getPercentage(n));
                                return percentage;
                            }
                        }
                    });

                    $this.asPieProgress('start');
                },{
                    offset: 'bottom-in-view'
                });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-progress-bar-circle', KFW_Progressbar_Circle );
    });
})( jQuery, window.elementorFrontend );
