(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler     = elementorModules.frontend.handlers.Base,
            KFW_Ripple_Button;

        KFW_Ripple_Button = moduleHandler.extend({
            getDefaultSettings() {
                settings = {};
                settings.selectors = {
                    main  : '.kfw-ele-widget-ripple-button',
                    ripple: ".kfw-ele-widget-ripple-button-hover"
                };

                return settings;
            },

            getDefaultElements() {
                let selectors = this.getSettings('selectors');

                return {
                    $main     : this.$element.find( selectors.main ),
                    $rippleEle: this.$element.find( selectors.ripple ),
                }
            },

            bindEvents: function () {
                let $this = this;

                $this._execute();
            },

            _execute() {
                let $this      = this,
                    $mainEle   = $this.elements.$main.get(0),
                    $rippleEle = $this.elements.$rippleEle.get(0);

                $($mainEle).mouseenter(function($e){
                    let $offset = $(this).offset(),
                        $relX   = $e.pageX - $offset.left,
                        $relY   = $e.pageY - $offset.top;

                    $($rippleEle).css({"left": $relX, "top": $relY });
                });

                $($mainEle).mouseleave(function($e){
                    let $offset = $(this).offset(),
                        $relX   = $e.pageX - $offset.left,
                        $relY   = $e.pageY - $offset.top;

                    $($rippleEle).css({"left": $relX, "top": $relY });
                });
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-ripple-button', KFW_Ripple_Button );
    });
})( jQuery, window.elementorFrontend );
