(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){

        let moduleHandler             = elementorModules.frontend.handlers.Base,
            KFW_Service_Vertical = '';

        KFW_Service_Vertical = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-cpt-service-vertical-main'
                    },
                    classes: {
                        active: 'kfw-active-item',
                    },
                }
            },
            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main         : this.$element.find( main ),
                    $frontSettings: this.$element.find( main ).data("settings"),
                }
            },
            bindEvents: function() {
                this._execute();
            },
            _execute() {
                let $id          = this.getID(),
                    $main        = this.elements.$main,
                    $settings    = this.elements.$frontSettings,
                    $activeClass = this.getSettings( 'classes.active' );

                    let $items = $(".kinfw-service-vertical-item", $main );
                    if( $settings.active_item === true && ( $settings.active_item_no <= $settings.total_items ) ){
                        $items.removeClass( $activeClass );
                        $items.eq($settings.active_item_no - 1).addClass( $activeClass );
                    }

                    $($items).on($settings.trigger, function(){
                        $(this).siblings().removeClass( $activeClass );
                        $(this).addClass( $activeClass );
                    });                    
                },
            });
    
            elementorFrontend.elementsHandler.attachHandler( 'kfw-cpt-service-vertical', KFW_Service_Vertical );
        });
    })( jQuery, window.elementorFrontend );                    
