(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler    = elementorModules.frontend.handlers.Base,
            KFW_Split_Scroll_Alt;

        KFW_Split_Scroll_Alt = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-split-scroll-alt-main'
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main: this.$element.find( main )
                }
            },

            bindEvents: function () {
                let $this   = this;
                if( !$this._isMobile() ) {
                    this._execute();
                }
            },

            _execute() {
                gsap.registerPlugin(ScrollTrigger);
                gsap.config({
                    nullTargetWarn: false,
                    trialWarn: false
                });

                let mm    = gsap.matchMedia();
                let $id   = this.getID();
                let $main = this.elements.$main;

                let $allImgSecs       = $('.kfw-elementor-split-scroll-alt-img-item', $main );
                let $allContentSecs   = $('.kfw-elementor-split-scroll-alt-content-item', $main );
                let $contentSecWrap   = $('.kfw-elementor-split-scroll-alt-r-items-wrap', $main );
                let $firstContentItem = $('.kfw-elementor-split-scroll-alt-content-item:first-child', $main );
                let $lastContentItem  = $('.kfw-elementor-split-scroll-alt-content-item:last-child', $main );

                let $allContentSecsAlt = $('.kfw-elementor-split-scroll-alt-content-wrap', $main );
                let $gap               = $allContentSecsAlt.length * 30;

                // this setup code only runs when viewport is at least 600px wide
                mm.add("(min-width: 768px)",function(){
                    gsap.timeline({
                        scrollTrigger:{
                            pin     : true,
                            scrub   : 1,
                            trigger : $contentSecWrap,
                            end     : () => "+=" + (($main.height() + $gap) - document.documentElement.clientHeight),
                            onUpdate: (self) => {
                                let $per = parseInt(self.progress * 100);
                                if ( $per > 99) {
                                    $lastContentItem.addClass("last");
                                } else {
                                    $lastContentItem.removeClass("last");
                                }

                                if ( $per < 1 ) {
                                    $firstContentItem.addClass("first");
                                } else {
                                    $firstContentItem.removeClass("first");
                                }
                            },
                        },
                        defaults: { ease: "none", duration: 1 }
                    });

                    $allImgSecs.each(function( $index, $item ){
                        let $pos = $allContentSecs[$index];
                        ScrollTrigger.create({
                            trigger    : $item,
                            start      : "top center",
                            end        : () => '+=' + $item.offsetHeight,
                            toggleClass: { targets: $pos, className: "active" }
                        });
                    });
                });
            },

            _isMobile() {
                let isAndroid    = navigator.userAgent.match(/Android/i),
                    isBlackBerry = navigator.userAgent.match(/BlackBerry/i),
                    isIOS        = navigator.userAgent.match(/iPhone|iPad|iPod/i),
                    isOpera      = navigator.userAgent.match(/Opera Mini/i),
                    isWindows    = navigator.userAgent.match(/IEMobile|Windows Phone/i);

                return (
                    isAndroid ||
                    isBlackBerry ||
                    isIOS ||
                    isOpera ||
                    isWindows
                );
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-split-scroll-alt', KFW_Split_Scroll_Alt );
    });
})( jQuery, window.elementorFrontend );
