<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Assets_Manager' ) ) {

	/**
	 * Elementor assets setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Assets_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            /**
             * Frontend Assets
             */
				add_action( 'elementor/frontend/after_register_scripts', [ $this, 'register_frontend_scripts' ], -1 );
				add_action( 'elementor/frontend/before_enqueue_styles', [ $this, 'enqueue_frontend_common_styles' ]  );
				add_action( 'elementor/frontend/after_register_styles', [ $this, 'register_frontend_styles' ] );

			/**
			 * Preview Assets
			 */
				add_action( 'elementor/preview/enqueue_styles', [ $this, 'enqueue_editor_preview_styles' ] );

            /**
             * Editor Assets
             */
				add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'enqueue_editor_styles' ] );
				add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'enqueue_editor_scripts' ] );

            do_action( 'kinfw-action/plugin/elementor/assets/loaded' );

		}

        /**
         * Register Elementor modules scripts
         */
        public function register_frontend_scripts() {
		}

        /**
         * Enqeue Elementor common styles
         */
        public function enqueue_frontend_common_styles() {

            $ext_motion_fx_active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/motion-fx', true );

            if( $ext_motion_fx_active && !defined('ELEMENTOR_PRO_VERSION') ) {

                wp_enqueue_script( 'kfe-ext-motion-fx-elementor',
                    KFE_CONST_URL . 'libraries/elementor/assets/js/motion-fx' . KFE_CONST_DEBUG_SUFFIX . '.js',
                    [ 'elementor-frontend-modules' ],
                    KFE_CONST_VERSION,
                    true
                );

            }


        }

        /**
         * Register Elementor modules styles
         */
        public function register_frontend_styles() {}

        /**
         * Enqueue Elementor editor preview styles
         */
        public function enqueue_editor_preview_styles() {
		}

        /**
         * Enqueue Elementor editor style
         */
        public function enqueue_editor_styles() {

            $ext_motion_fx_active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/motion-fx', true );

            if( $ext_motion_fx_active && !defined('ELEMENTOR_PRO_VERSION') ) {

                wp_enqueue_script( 'kfe-ext-motion-fx-elementor',
                    KFE_CONST_URL . 'libraries/elementor/assets/js/motion-fx' . KFE_CONST_DEBUG_SUFFIX . '.js',
                    [ 'elementor-frontend-modules' ],
                    KFE_CONST_VERSION,
                    true
                );

            }

			wp_enqueue_style( 'kfe-elementor-editor', KFE_CONST_URL . 'libraries/elementor/assets/css/editor' . KFE_CONST_DEBUG_SUFFIX . '.css' );
			wp_enqueue_style( 'kfe-elementor-icon', KFE_CONST_URL . 'libraries/elementor/assets/css/editor-icons' . KFE_CONST_DEBUG_SUFFIX . '.css' );

		}

        /**
         * Enqueue Elementor editor script
         */
        public function enqueue_editor_scripts() {

            wp_localize_script( 'jquery', 'KIN_FW_EXTRA_ELEMENTOR_OBJ', [
                'pluginName'    => KFE_CONST_PLUGIN_NAME,
                'pluginSanName' => KFE_CONST_SAN_PLUGIN_NAME,
                'pluginVersion' => KFE_CONST_VERSION,
            ] );

			wp_enqueue_script( 'kfe-elementor-editor',
				KFE_CONST_URL . 'libraries/elementor/assets/js/editor' . KFE_CONST_DEBUG_SUFFIX . '.js',
				[ 'backbone-marionette', 'elementor-common-modules', 'elementor-editor-modules' ],
				KFE_CONST_VERSION,
				true
			);
		}

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_assets_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_assets_manager() {

        return KinForce_Extra_Plugin_Elementor_Assets_Manager::get_instance();
    }
}

kf_extra_plugin_elementor_assets_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */