<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Modules_WP_Ajax_Manager' ) ) {

	/**
	 * Elementor modules setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Modules_WP_Ajax_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            /**
             * Mailchimp Widget : Sbuscription
             */
            add_action( 'wp_ajax_kinfw-action/plugins/elementor/widget/kfw-mailchimp/subscribe', [ $this, 'subscribe' ] );
            add_action( 'wp_ajax_nopriv_kinfw-action/plugins/elementor/widget/kfw-mailchimp/subscribe', [ $this, 'subscribe' ] );

            /**
             * Mailchimp Plus Widget : Sbuscription
             */
            add_action( 'wp_ajax_kinfw-action/plugins/elementor/widget/kfw-mailchimp-plus/subscribe', [ $this, 'subscribe_plus' ] );
            add_action( 'wp_ajax_nopriv_kinfw-action/plugins/elementor/widget/kfw-mailchimp-plus/subscribe', [ $this, 'subscribe_plus' ] );
        }

        /**
         * Mailchimp Widget : Sbuscription fallback
         */
        public function subscribe() {
            $akey = sanitize_text_field($_POST['akey']);
            $aid  = sanitize_text_field($_POST['aid']);
            $data = [
                'email_address' => wp_unslash ($_POST['email'] ),
                'status'        => 'subscribed'
            ];

            $result = $this->mailchimp_api_call( $akey, $aid, $data );

            if ('subscribed' === $result->status || 200 === $result->status ) {
                wp_send_json_success([
                    'message' => sprintf('<div class="kinfw-notice kinfw-success-msg">%1$s</div>', sanitize_text_field( $_POST['success'] ) ),
                ]);
            } else if( 401 === $result->status ) {
                wp_send_json_error([
                    'message' => sprintf(
                        '<div class="kinfw-notice kinfw-failure-msg">%1$s</div>',
                        esc_html__('API keys and Audience ID are not configured.', 'onnat-extra' )
                    ),
                ]);
            } else if( 400 === $result->status ) {
                $message = '';
                if (isset($result->detail) && !empty($result->detail)) {
                    $message = $result->detail;
                } else {
                    $message = esc_html__('We were unable to process your request.', 'onnat-extra' );
                }

                wp_send_json_error([
                    'message' => sprintf('<div class="kinfw-notice kinfw-failure-msg">%1$s</div>', $message ),
                ]);
            } else {
                wp_send_json_error([
                    'message' => sprintf(
                        '<div class="kinfw-notice kinfw-failure-msg">%1$s</div>',
                        esc_html__('something went wrong.', 'onnat-extra' )
                    ),
                ]);
            }

            wp_die();
        }

        /**
         * Mailchimp Plus Widget : Sbuscription fallback
         */
        public function subscribe_plus() {
            $akey = sanitize_text_field($_POST['akey']);
            $aid  = sanitize_text_field($_POST['aid']);
            $data = [
                'email_address' => wp_unslash ($_POST['email'] ),
                'status'        => 'subscribed',
                'merge_fields'  => [
                    'FNAME' => '',
                    'LNAME' => ''
                ]
            ];

            /**
             * Split Name to First & Last Name
             */
            $name      = sanitize_text_field($_POST['name']);
            $splitName = explode(' ', $name, 2 );

            if( count($splitName) > 1 ) {
                $data['merge_fields']['FNAME'] = $splitName[0];
                $data['merge_fields']['LNAME'] = $splitName[1];
            } else {
                $data['merge_fields']['FNAME'] = $splitName[0];
            }

            $result = $this->mailchimp_api_call( $akey, $aid, $data );

            if ('subscribed' === $result->status || 200 === $result->status ) {
                wp_send_json_success([
                    'message' => sprintf('<div class="kinfw-notice kinfw-success-msg">%1$s</div>', sanitize_text_field( $_POST['success'] ) ),
                ]);
            } else if( 401 === $result->status ) {
                wp_send_json_error([
                    'message' => sprintf(
                        '<div class="kinfw-notice kinfw-failure-msg">%1$s</div>',
                        esc_html__('API keys and Audience ID are not configured.', 'onnat-extra' )
                    ),
                ]);
            } else if( 400 === $result->status ) {
                $message = '';
                if (isset($result->detail) && !empty($result->detail)) {
                    $message = $result->detail;
                } else {
                    $message = esc_html__('We were unable to process your request.', 'onnat-extra' );
                }

                wp_send_json_error([
                    'message' => sprintf('<div class="kinfw-notice kinfw-failure-msg">%1$s</div>', $message ),
                ]);
            } else {
                wp_send_json_error([
                    'message' => sprintf(
                        '<div class="kinfw-notice kinfw-failure-msg">%1$s</div>',
                        esc_html__('something went wrong.', 'onnat-extra' )
                    ),
                ]);
            }

            wp_die();
        }

        /**
         * Mailchimp API call
         */
        public function mailchimp_api_call( $api_key, $audience_id, $data = [] ) {
            $args = [
                'method'  => 'PUT',
                'body'    => json_encode( $data ),
                'headers' => [
                    'Authorization' => 'Basic ' . base64_encode('user:' . $api_key)
                ],
            ];

            $response = wp_remote_post('https://' . substr($api_key, strpos($api_key, '-') + 1) . '.api.mailchimp.com/3.0/lists/' . $audience_id . '/members/' . md5(strtolower($data['email_address'])), $args);

            if( !is_wp_error( $response ) ) {
                return json_decode($response['body']);
            }
            return;
        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_modules_wp_ajax_manager' ) ) {
    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_modules_wp_ajax_manager() {
        return KinForce_Extra_Plugin_Elementor_Modules_WP_Ajax_Manager::get_instance();
    }
}
kf_extra_plugin_elementor_modules_wp_ajax_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */