<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Wrapper_Link' ) ) {

	/**
	 * Elementor Extension: Wrapper Link setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Wrapper_Link {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/wrapper-link/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/wrapper-link', $this->active );

            if( $this->active ) {

                add_action('elementor/element/container/section_layout/before_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/section/section_structure/after_section_end', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/column/section_typo/after_section_end', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/common/_section_style/after_section_end', [ $this, 'register_section' ], 10, 2 );

                add_action( 'elementor/frontend/before_render', [ $this, 'add_cover_link_attributes_to_elements' ] );

            }

        }

        public function register_section( $element, $section_id ) {
            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );

            $tab = Elementor\Controls_Manager::TAB_CONTENT;

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                case 'column':
                    $tab = Elementor\Controls_Manager::TAB_LAYOUT;
                break;

                default:
                    $name = esc_html__( 'Widget', 'onnat-extra' );
                    $tab  = Elementor\Controls_Manager::TAB_CONTENT;
                break;
            }

            $this->_register_wrapper_url_section( $element, $name, $tab );

        }

        public function _register_wrapper_url_section( $controls_stack, $name, $tab ) {

            $controls_stack->start_controls_section( 'kfw_section_wrapper_url', [
                'label' => sprintf( __( '%s Cover Link', 'onnat-extra'), $name ),
                'tab'   => $tab
            ] );

                $controls_stack->add_control( 'wrapper_url', [
                    'type'                          => Elementor\Controls_Manager::URL,
                    'label'                         => esc_html__( 'Link', 'onnat-extra' ),
                    'placeholder'                   => 'https://example.com',
                    'show_external'                 => true,
                    'default'                       => ['url' => ''],
                    'dynamic'                       => ['active' => false],
                    'render_type'                   => 'none',
                    'custom_attributes_description' => esc_html__( 'Custom Attributes option will not work at this time.', 'onnat-extra'),
                ] );


                $controls_stack->add_control( 'wrapper_link_description', [
                    'raw'             => sprintf( __( 'Cover Link enables you to attach link to %s.', 'onnat-extra'), $name ),
                    'type'            => Elementor\Controls_Manager::RAW_HTML,
                    'content_classes' => 'elementor-descriptor',
                ] );

            $controls_stack->end_controls_section();
        }

        public function add_cover_link_attributes_to_elements( $element ) {

            $settings = $element->get_settings( 'wrapper_url' );
            $settings = is_array( $settings ) ? array_filter( $settings ) : [];

            if( !$settings ) {
                return;
            }

            if( !array_key_exists( 'url', $settings ) ) {
                return;
            }

            $element->add_render_attribute( '_wrapper', [
                'class'                          => 'kinfw-element-cover-link kinfw-js-element-cover-link',
                'style'                          => 'cursor: pointer',
                'data-kinfw-cover-link-settings' => json_encode( $settings )
            ] );
        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_wrapper_link' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_wrapper_link() {

        return KinForce_Extra_Plugin_Elementor_Extension_Wrapper_Link::get_instance();
    }
}

kf_extra_plugin_elementor_extension_wrapper_link();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */