<?php
/**
 * Widget Template : Blog Post Single Featured Image
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$post_title = get_the_title();
$mode       = $this->_is_editor_mode();

if( $mode ) {
    $post_id    = kf_extra_plugin_elementor()->get_latest_post_id( 'post' );
    $post_title = get_the_title( $post_id );
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-featured-image-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-post-featured-image-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $thumbnail_id = get_post_thumbnail_id( $post_id );
    $image_src    = $this->_get_image_src( $thumbnail_id, 'image_size', $settings );

    $image_title = $this->_get_featured_image_title( $thumbnail_id );
    $image_title = empty( $image_title ) ? $post_title : $image_title;

    $image_alt = $this->_get_featured_image_alt( $thumbnail_id );
    $image_alt = empty( $image_alt ) ? $image_title : $image_alt;

    if( !empty( $image_src ) ) {
        $this->add_render_attribute( 'image_attr', [
            'class' => array_filter([
                'kfw-ele-widget-post-featured-image',
                !empty( $settings['hover_animation'] ) ? 'elementor-animation-'.esc_attr( $settings['hover_animation'] ): '',
            ]),
            'alt'   => esc_attr( $image_alt ),
            'title' => esc_attr( $image_title ),
            'src'   => esc_url( $image_src ),
        ] );

        echo '<img '.$this->get_render_attribute_string( 'image_attr' ).'/>';
    }

echo '</div>';