<?php
/**
 * Widget Template : Blog Post Single Post Format Info
 */

$settings    = $this->get_settings();
$post_id     = get_the_ID();
$post_format = get_post_format( $post_id );
$mode        = $this->_is_editor_mode();

if( $mode ) {
    $post_id     = kf_extra_plugin_elementor()->get_latest_post_id( 'post' );
    $post_format = get_post_format( $post_id );
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-format-info-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-post-format-info-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $the_query = new WP_Query([
        'post_status'   => 'publish',
        'post_type'     => 'post',
        'no_found_rows' => true,
        'p'             => $post_id,
    ]);

    if( $the_query->have_posts() ) {
        $the_query->the_post();

        get_template_part( 'template-parts/single-post/style-2/headers/entry-header', get_post_format() );

    }
    wp_reset_postdata();

echo '</div>';