<?php
/**
 * Widget Template : Content Carousel
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'            => 'kfw-ele-widget-content-carousel-'.esc_attr( $this->get_id() ),
	'class'         => [
        'kfw-ele-widget-content-carousel-main'
    ],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'swiper', [
        'data-id' => 'kfw-js-swiper-'.esc_attr( $this->get_id() ),
        'class'   => array_filter( [
            'kfw-js-swiper-'.esc_attr( $this->get_id() ),
            'kfw-swiper',
            'swiper',
            'swiper-container',
        ])
    ]);
    echo '<div '. $this->get_render_attribute_string( 'swiper' ) .'>';

        $this->add_render_attribute( 'list', [
            'class' => array_filter( [
                'kfw-ele-content-carousel-list',
                'swiper-wrapper'
            ])
        ]);
        echo '<div '. $this->get_render_attribute_string( 'list' ) .'>';

            foreach( $items as $index => $item ) {
                if( $item['template'] != '0' && !empty( $item['template'] ) ) {
                    $b_item  = $this->get_repeater_setting_key( 'b-item', 'b-items', $index );
                    $classes = [
                        'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                        'kfw-ele-widget-content-carousel-item',
                        'swiper-slide',
                    ];

                    $this->add_render_attribute( $b_item, [ 'class' => array_filter( $classes ) ] );
                    echo '<div '. $this->get_render_attribute_string( $b_item ) .'>';
                        echo '<div class="kfw-content-carousel-template-wrap">';
                            echo $this->_generate_template_content( $item['template'] );
                        echo '</div>';
                    echo '</div>';
                }
            }

        echo '</div>';

    echo '</div>';

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] !== 'custom' ) {
        /**
         * Navigation
         */
        $this->add_render_attribute( 'navEl', [
            'class' => array_filter( [
                'kfw-content-carousel-nav-wrap',
                'kfw-content-carousel-nav-pos-'. $settings['arrow_position'],
                $settings['mobile_arrows'] === 'yes' ? 'hide-on-sm hide-on-xs' : ''
            ] )
        ] );

        echo '<div '.$this->get_render_attribute_string( 'navEl' ).'>';

            $this->add_render_attribute( 'prevEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-prev',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'prevEl' ).'>';
                $this->_render_icon( $settings['right_arrow'] );
            echo '</div>';

            $this->add_render_attribute( 'nextEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-next',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'nextEl' ).'>';
                $this->_render_icon( $settings['left_arrow'] );
            echo '</div>';

        echo '</div>';
    }

    if( $settings['dots'] === 'yes' ) {

        /**
         * Pagination
         */
        $this->add_render_attribute( 'pagination', [
            'class' => array_filter( [
                'kfw-swiper-pagination',
                'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination'
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'pagination' ).'></div>';
    }

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] === 'custom' ) {
        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-next %2$s for Next Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );

        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-prev %2$s for Prev Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );
    }    

echo '</div>';