<?php
/**
 * Widget Template : Blog Post Single - Post Navigation
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$post_title = get_the_title();
$mode       = $this->_is_editor_mode();

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-next-prev-post-nav-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-post-next-prev-post-nav-main',
        'kfw-post-nav-type',
        'kfw-post-nav-'. $settings['type']
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    if( $mode ) {
        $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-project' );

        global $post;
        $post = get_post( $post_id, OBJECT );
        setup_postdata( $post );
    }

    $prev_post    = get_adjacent_post(  false, '', true, 'kinfw-project-category' );
    $is_prev_post = is_a( $prev_post, 'WP_Post' );
    $next_post    = get_adjacent_post(  false, '', false, 'kinfw-project-category' );
    $is_next_post = is_a( $next_post, 'WP_Post' );


    if( $is_prev_post || $is_next_post ) {
        $pagination_classes = '';

        if( $is_next_post && empty( $is_prev_post ) ) {
            $pagination_classes = 'kfw-only-one-post-nav kfw-has-next-post-only';
        } elseif( $is_prev_post && empty( $is_next_post) ) {
            $pagination_classes = 'kfw-only-one-post-nav kfw-has-prev-post-only';
        }

        printf( '<div class="kinfw-post-nav %1$s">', $pagination_classes );
            if ( $is_prev_post ) {
                $prev_icon_type = $settings['prev_post_icon_type'];

                echo '<div class="kinfw-post-nav-prev">';
                    echo '<a href="'.esc_url( get_permalink( $prev_post->ID ) ).'">';

                        echo '<span class="kinfw-post-nav-txt-wrap">';
                            if( $prev_icon_type  !== 'blank' ) {
                                if( $prev_icon_type === 'icon' ) {
                                    $this->_render_icon( $settings['prev_post_icon'] );
                                }

                                if( $prev_icon_type === 'image' ) {
                                    $this->_render_img( $settings['prev_post_image'] );
                                }
                            }

                            echo '<span class="kinfw-post-nav-txt">';
                                echo esc_html( $settings['prev_post_title'] );
                            echo '</span>';
                        echo '</span>';

                        if( $settings['type'] === 'type-1' ) {
                            echo '<span class="kinfw-post-nav-title">';
                                echo wp_kses_post( $prev_post->post_title );
                            echo '</span>';
                        }

                    echo '</a>';
                echo '</div>';                
            }

            if ( $is_next_post ) {
                $next_icon_type = $settings['next_post_icon_type'];

                echo '<div class="kinfw-post-nav-next">';
                    echo '<a href="'.esc_url( get_permalink( $next_post->ID ) ).'">';

                        echo '<span class="kinfw-post-nav-txt-wrap">';
                            if( $next_icon_type  !== 'blank' ) {
                                if( $next_icon_type === 'icon' ) {
                                    $this->_render_icon( $settings['next_post_icon'] );
                                }

                                if( $next_icon_type === 'image' ) {
                                    $this->_render_img( $settings['next_post_image'] );
                                }
                            }

                            echo '<span class="kinfw-post-nav-txt">';
                                echo esc_html( $settings['next_post_title'] );
                            echo '</span>';
                        echo '</span>';

                        if( $settings['type'] === 'type-1' ) {
                            echo '<span class="kinfw-post-nav-title">';
                                echo wp_kses_post( $next_post->post_title );
                            echo '</span>';
                        }

                    echo '</a>';
                echo '</div>';                
            }
        printf( '</div>' );
    }

    if ( $mode ) {
        wp_reset_postdata();
    }

echo '</div>';