<?php
/**
 * Widget Template :  CPT Project Post Single Social Links
 */

$settings = $this->get_settings();
$post_id  = get_the_ID();
$mode     = $this->_is_editor_mode();

if( $mode ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-project' );
}

$social_order        = kinfw_onnat_theme_options()->kinfw_get_option( 'single_kinfw_project_social_share' );
$active_social_share = isset( $social_order['enabled'] ) ? apply_filters( 'kinfw-filter/theme/util/is-array', $social_order['enabled'] ) : [];

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-project-social-share-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-project-social-share-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $meta  = get_post_meta( $post_id, '_kinfw_cpt_project_options', true );
    $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

    $links = [];
    foreach( $active_social_share as $social_id => $social_name ) {
        if( isset( $meta[ $social_id ] ) && !empty( $meta[ $social_id ] ) ) {
            $links[ $social_id ] = $meta[ $social_id ];
        }
    }

    if( count( $links ) ) {
        echo '<ul class="kinfw-social-links">';
            foreach( $links as $social_id => $social_link ) {
                echo '<li>';
                    echo sprintf('<a href="%s"></a>', $social_link );
                echo '</li>';
            }
        echo '</ul>';
    }

echo '</div>';