<?php
/**
 * Widget Template : Project Taxonomy
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$post_title = get_the_title();
$mode       = $this->_is_editor_mode();

if( $mode ) {
    $post_id    = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-project' );
    $post_title = get_the_title( $post_id );
}

$title = '';
$data  = '';

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-project-taxonomy-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-project-taxonomy-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    if( 'yes' === $settings['add_title'] ) {
        $title = $settings['title'];

        if( empty( $title ) ) {
            $title = esc_html__( 'Category:', 'onnat-extra' );
        }
    }

    $terms_list = get_the_term_list( $post_id, 'kinfw-project-category', '', ', ', '' );

    if ( $terms_list ) {

        if( !empty( $title ) ) {
            printf( '<span class="kfw-ele-cpt-project-tax-title">%s</span>', esc_html( $title ) );
        }

        printf( '
            <ul class="kinfw-project-tax-list">
                <li>
                    %1$s
                </li>
            </ul>',
            str_replace( ', ', ', </li> <li>', $terms_list )
        );
    } else {
        $this->_message(
            sprintf( esc_html__('Select the %s for this %s project.', 'onnat-extra' ), $this->taxonomy_name('kinfw-project-category'), $post_title )
        );
    }

echo '</div>';