<?php
/**
 * Widget Template : Team Member Taxonomy
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$post_title = get_the_title();

if( is_singular( 'elementor_library' ) ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-team-member' );
}

$title = '';
$data  = '';

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-team-member-taxonomy-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-team-member-taxonomy-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    if( 'yes' === $settings['add_title'] ) {
        $title = $settings['title'];

        if( empty( $title ) ) {
            $title = esc_html__( 'Team Group', 'onnat-extra' );
        }
    }

    $terms_list = get_the_term_list( $post_id, 'kinfw-team-group', '', ', ', '' );

    if ( $terms_list ) {

        if( !empty( $title ) ) {
            printf( '<span class="kfw-ele-cpt-team-member-tax-title">%s</span>', esc_html( $title ) );
        }

        printf( '
            <ul class="kinfw-team-member-tax-list">
                <li>
                    %1$s
                </li>
            </ul>',
            str_replace( ', ', ', </li> <li>', $terms_list )
        );
    } else {
        $this->_message(
            sprintf( esc_html__('Select the %s for this %s team member.', 'onnat-extra' ), $this->taxonomy_name('kinfw-team-group'), $post_title )
        );
    }

echo '</div>';