<?php
/**
 * Widget Template : Header Action Icons
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-header-group-action-'.esc_attr( $this->get_id() ),
	'class' => [ 'kinfw-header-group-action', 'kfw-ele-widget-header-group-action-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
	foreach( $items as $index => $item ):

		switch( $item['action'] ) {
			case 'cart':
				$this->render_cart_action_icon( $item );
			break;

			case 'hamburger':
				$this->render_hamburger_action_icon( $item );
			break;

			case 'search':
				$this->render_search_action_icon( $item );
			break;

			case 'user_account':
				$this->render_user_account_action_icon( $item );
			break;

			case 'wishlist':
				$this->render_wishlist_action_icon( $item );
			break;
		}
	endforeach;
echo '</div>';