<?php
/**
 * Widget Template : Image Accordion
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'wrapper', [
	'id'            => 'kfw-elementor-widget-image-accordion-'.esc_attr( $this->get_id() ),
	'class'         => array_filter([
        'kfw-elementor-widget-image-accordion-wrapper',
        ( $settings['content_style'] === 'yes' ) ? 'kfw-elementor-image-accordion-content-fill-style' : 'kfw-elementor-image-accordion-content-boxed-style',
        ( $settings['use_anim'] === 'yes' ) ? $settings['anim_type'] : ''
    ]),
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

    /**
     * Items
     */
    $items = $settings['items'];
    if( $items ) {
        foreach( $items as $index => $item ) {

            $item_wrapper = $this->get_repeater_setting_key( 'item', 'kfw-items', $index );

            $this->add_render_attribute( $item_wrapper, [
                'id'    => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class' => array_filter([
                    'kfw-elementor-image-accordion-item',
                ])
            ]);

            echo '<div '.$this->get_render_attribute_string( $item_wrapper ).'>';

                /**
                 * Image
                 */
                    $item_image_wrapper = $this->get_repeater_setting_key( 'image-item-wrap', 'kfw-items', $index );
                    $this->add_render_attribute( $item_image_wrapper, [
                        'class' => array_filter([
                            'kfw-elementor-image-accordion-image-wrapper',
                        ])
                    ]);

                    echo '<div '.$this->get_render_attribute_string( $item_image_wrapper ).'>';

                        $image_src = $this->_get_image_src( $item['image']['id'], 'image_size', $settings );
                        $image_src = empty($image_src) ? $item['image']['url'] : $image_src;

                        $image_title = $this->_get_image_title( $item['image'] );
                        $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                        $image_alt = $this->_get_image_alt( $item['image'] );
                        $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                        $image_attr = $this->get_repeater_setting_key( 'image-item', 'kfw-items', $index );
                        $this->add_render_attribute( $image_attr, [
                            'class' => 'kfw-elementor-widget-image-accordion-image kfw-image-is-loading',
                            'alt'   => esc_attr( $image_alt ),
                            'title' => esc_attr( $image_title ),
                            'src'   => esc_url( $image_src ),
                        ]);

                        echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';

                        if( 'yes' === $settings['show_index'] ) {
                            $item_index_wrapper = $this->get_repeater_setting_key( 'image-index-wrap', 'kfw-items', $index );
                            $this->add_render_attribute( $item_index_wrapper, [
                                'class' => array_filter([
                                    'kfw-elementor-image-accordion-index-wrapper',
                                ])
                            ]);
        
                            echo '<div '.$this->get_render_attribute_string( $item_index_wrapper ).'>';
                                echo $this->_formatted_number( $index+1 );
                            echo '</div>';
                        }        

                    echo '</div>';

                /**
                  * Content
                  */
                    $item_content_wrapper = $this->get_repeater_setting_key( 'content-item-wrap', 'kfw-items', $index );
                    $this->add_render_attribute( $item_content_wrapper, [
                        'class' => array_filter([
                            'kfw-elementor-image-accordion-content-wrapper',
                        ])
                    ]);

                    echo '<div '.$this->get_render_attribute_string( $item_content_wrapper ).'>';
                        /**
                         * Title
                         */
                            $title = $item['title'];
                            if( !empty( $title ) ) {
                                echo '<div class="kfw-elementor-image-accordion-title">'. esc_html( $title ) . '</div>';
                            }

                        /**
                         * Sub Title
                         */
                            $stitle = $item['sub_title'];
                            if( !empty( $stitle ) ) {
                                echo '<div class="kfw-elementor-image-accordion-sub-title">'. esc_html( $stitle ) . '</div>';
                            }

                        /**
                         * Content
                         */
                            $content = $item['content'];
                            if( !empty( $content ) ) {
                                echo '<div class="kfw-elementor-image-accordion-content">'. $this->parse_text_editor( $item['content'] ) . '</div>';
                            }

                        /**
                         * Title
                         */
                        $button_txt = $item['button_txt'];
                        if( !empty( $button_txt ) ) {
                            $link = array_filter( $item['button_link'] );

                            if( !empty( $link ) ) {
                                $item_button = $this->get_repeater_setting_key( 'item-button', 'kfw-items', $index );

                                $this->add_render_attribute( $item_button, [
                                    'href'  => esc_url( $link['url'] ),
                                    'class' => 'kfw-elementor-image-accordion-button'
                                ]);

                                if( isset( $link['is_external'] ) ) {
                                    $this->add_render_attribute( $item_button, 'target', '_blank' );
                                }

                                if( isset( $link['nofollow'] ) ) {
                                    $this->add_render_attribute( $item_button, 'rel', 'nofollow' );
                                }

                                echo '<a '.$this->get_render_attribute_string( $item_button ).'>';
                                    echo esc_html( $button_txt );
                                echo '</a>';
                            }
                        }
                    echo '</div>';

            echo '</div>';
        }
    }

echo '</div>';