<?php
/**
 * Widget Template : Image Stack
 */
$settings  = $this->get_settings();

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-image-stack-'.esc_attr( $this->get_id() ),
    'class' => [ 
        'kfw-ele-widget-image-stack-main',
        ( $settings['reverse_it'] === 'yes' ) ? 'kfw-ele-image-stack-reverse' : ''
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $ele_type = $settings['stack_element'];

    if( $ele_type === 'icon' ) {

        $items = $settings['icon_items'];

        if( count( $items ) ) {

            $this->add_render_attribute( 'wrap', [
                'class' => [ 'kfw-ele-image-stack-wrap' ],
            ]);

            echo '<ul '.$this->get_render_attribute_string( 'wrap' ).'>';

            foreach( $items as $index => $litem ) {
                $item = $this->get_repeater_setting_key( 'litem', 'items', $index );

                $this->add_render_attribute( $item, [
                    'class' => array_filter([
                        'elementor-repeater-item-' . esc_attr( $litem['_id'] ),
                        'kfw-ele-widget-image-stack-icon-type',
                        'kfw-ele-widget-image-stack-item',
                    ])
                ]);

                echo '<li '.$this->get_render_attribute_string( $item ).'>';
                    $this->_render_icons( $litem['icon'] );
                echo '</li>';
            }

            /**
             * Last Element
             */
                $this->_last_ele( $settings );

            echo '</ul>';
        }

    } else if( $ele_type === 'image' ) {

        $items = $settings['image_items'];
        if( count( $items ) ) {

            $this->add_render_attribute( 'wrap', [
                'class' => [ 'kfw-ele-image-stack-wrap' ],
            ]);

            echo '<ul '.$this->get_render_attribute_string( 'wrap' ).'>';

            foreach( $items as $index => $litem ) {
                $item = $this->get_repeater_setting_key( 'litem', 'items', $index );

                $this->add_render_attribute( $item, [
                    'class' => array_filter([
                        'elementor-repeater-item-' . esc_attr( $litem['_id'] ),
                        'kfw-ele-widget-image-stack-image-type',
                        'kfw-ele-widget-image-stack-item',
                    ])
                ]);

                echo '<li '.$this->get_render_attribute_string( $item ).'>';
                    $this->_render_img( $litem );
                echo '</li>';
            }

            /**
             * Last Element
             */
                $this->_last_ele( $settings );

            echo '</ul>';
        }

    } else if( $ele_type === 'text' ) {

        $items = $settings['text_items'];
        if( count( $items ) ) {

            $this->add_render_attribute( 'wrap', [
                'class' => [ 'kfw-ele-image-stack-wrap' ],
            ]);

            echo '<ul '.$this->get_render_attribute_string( 'wrap' ).'>';

            foreach( $items as $index => $litem ) {
                $item = $this->get_repeater_setting_key( 'litem', 'items', $index );

                $this->add_render_attribute( $item, [
                    'class' => array_filter([
                        'elementor-repeater-item-' . esc_attr( $litem['_id'] ),
                        'kfw-ele-widget-image-stack-text-type',
                        'kfw-ele-widget-image-stack-item',
                    ])
                ]);

                echo '<li '.$this->get_render_attribute_string( $item ).'>';
                    echo '<span class="kfw-elementor-icon-wrap">';
                    echo $litem['text'];
                    echo '</span>';
                echo '</li>';
            }

            /**
             * Last Element
             */
                $this->_last_ele( $settings );

            echo '</ul>';
        }

    }

echo '</div>';