<?php
/**
 * Widget Template : Info Box
 */
$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-info-box-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-info-box-main' ],
	'dir'   => is_rtl() ? 'rtl' : 'ltr'
]);

    /**
     * Info Box Animation
     */
    if( $settings['add_box_animation_hover'] == 'yes' && !empty( $settings['add_box_animation_hover'] ) ) {
        $this->add_render_attribute( 'main', [
            'class' => [ 'elementor-animation-'.esc_attr( $settings['box_animation_hover'] ) ],
        ] );
    }

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	/**
	 * Title & Sub Title
	 */
	$this->_titles( $settings );

	/**
	 * Features
	 */
	$features = array_filter(  $settings['features'] );
	if( !empty( $features )) {

		$this->add_render_attribute( 'features-list', [
			'class' => array_filter( [
				'kfw-ele-info-box-features-list'
			] ),
		]);

		echo '<ul '. $this->get_render_attribute_string( 'features-list' ) .'>';
		foreach( $features as $index => $item ) {

			$feature = $this->get_repeater_setting_key( 'feature', 'features', $index );

			$this->add_render_attribute( $feature, [
				'class' => array_filter( [
					'kfw-ele-info-box-features-list-item',
					'elementor-repeater-item-' . esc_attr( $item['_id'] ),
				] )
			] );

			echo '<li '. $this->get_render_attribute_string( $feature ) .'>';
				if( !empty( $item['label'] ) ) {
					echo "<span class='kfw-ele-info-box-features-list-item-label'>";
						$this->_render_icons( $item['icon'] );
						echo esc_html( $item["label"] );
					echo "</span>";
				}
			echo '</li>';

		}
		echo '</ul>';
	}

    /**
     * Button
     */
    $this->_button( $settings );

echo '</div>';