<?php
/**
 * Widget Template : Info List Minimal
 */

$settings = $this->get_settings();
$items    = $settings['items'];

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-widget-info-list-minl-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-info-list-minl-wrapper' ],
] );

if( $settings['order'] === 'descending' ) {
    $this->add_render_attribute( 'wrapper', [
        'style' => 'counter-reset:'.$this->_counter() .' '.count( $items )
    ]);
}

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';
    /**
     * Items
     */
    if( $items ) {
        foreach( $items as $index => $litem ) {

            $item = $this->get_repeater_setting_key( 'litem', 'items', $index );

            $this->add_render_attribute( $item, [
                'class' => array_filter([
                    'elementor-repeater-item-' . esc_attr( $litem['_id'] ),
                    'kfw-ele-widget-info-list-minl-item',
                    !empty( $litem[ 'css_classes' ] ) ? esc_attr( $litem['css_classes'] ) : "",
                ])
            ] );

            echo '<div '.$this->get_render_attribute_string( $item ).'>';

                /**
                 * Shape
                 */
                    echo '<span class="kfw-ele-widget-info-list-minl-shape"></span>';

                /**
                 * Title
                 */
                if( !empty( $litem['title'] ) ) {
                    echo '<div class="kfw-ele-widget-info-list-minl-title">';
                        $link = array_filter( $litem['title_link'] );

                        if( !empty( $link ) && isset( $link['url']) ) {

                            $item_link = $this->get_repeater_setting_key( 'litem-link', 'items', $index );

                            $this->add_render_attribute( $item_link, [
                                'class' => [ 'kfw-ele-widget-info-list-minl-title-linked' ],
                                'href'  => esc_url( $link['url'] ),
                            ]);

                            if( isset( $link['is_external'] ) ) {
                                $this->add_render_attribute( $item_link, 'target', '_blank' );
                            }

                            if( isset( $link['nofollow'] ) ) {
                                $this->add_render_attribute( $item_link, 'rel', 'nofollow' );
                            }

                            echo '<a '.$this->get_render_attribute_string( $item_link ).'>';
                        }

                            echo $litem['title'];

                        if( !empty( $link ) && isset( $link['url']) ) {
                            echo '</a>';
                        }

                    echo '</div>';
                }

                /**
                 * Info
                 */
                if( !empty( $litem['info'] ) ) {
                    echo '<div class="kfw-ele-widget-info-list-minl-info">';
                        echo wp_kses_post( $litem['info'] );
                    echo '</div>';
                }

            echo '</div>';
        }
    }

echo '</div>';