<?php
/**
 * Widget Template : Interactive Image
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-interactive-image-'.esc_attr( $this->get_id() ),
    'class'         => ['kfw-ele-widget-interactive-image-main', ],
    'data-settings' => $this->_generate_setting_json( $settings ),
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Content Section
     */
    echo '<div class="kfw-inter-img-section-wrap kfw-content-section-wrap">';
        foreach( $items as $index => $item ):

            $accordion_item = $this->get_repeater_setting_key( 'accordion_item', 'items', $index );
            $this->add_render_attribute( $accordion_item, [
                'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class'   => array_filter([
                    'kfw-elementor-inter-img-item',
                    'kfw-elementor-inter-img-content-item',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $accordion_item ).'>';
                echo '<div class="kfw-inter-img-header-wrap" data-id="elementor-repeater-item-'.esc_attr( $item['_id'] ).'">';

                    /**
                     * Icon
                     */
                        if( $settings['use_title_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                            if( $item['icon_type'] === 'icon' ) {
                                $this->_render_icon( $item['icon'] );
                            } else if( $item['icon_type'] === 'image' ) {
                                $this->_render_img( $item['image'] );
                            } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                                $src = '';
                                if( $item['icon_type'] === 'lordicon_media' ) {
                                    $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                                } else if( $item['icon_type'] === 'lordicon_external' ) {
                                    $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                                }

                                if( !empty( $src ) ) {
                                    $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                                    $this->add_render_attribute( $lordicon, [
                                        'class'   => 'kfw-elementor-lordicon',
                                        'src'     => $src,
                                        'stroke'  => 45,
                                        'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                        'trigger' => 'click'
                                    ]);

                                    /**
                                     * Colors
                                     */
                                        $colors = '';
                                        $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                        $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                        $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                        if( !empty( $colors ) ) {
                                            $this->add_render_attribute( $lordicon, 'colors', $colors );
                                        }

                                    echo '<div class="kfw-inter-img-title-icon-wrap kfw-inter-img-title-lordicon-type">';
                                        echo '<span class="kfw-elementor-icon-wrap">';
                                            echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                        echo '</span>';
                                    echo '</div>';
                                }
                            }

                        }

                    /**
                     * Title
                     */
                        $title     = trim( $item['title'] );
                        $sub_title = trim( $item['sub_title'] );
                        if( !empty( $title ) || !empty( $sub_title ) ) {
                            echo '<div class="kfw-inter-img-title-wrap">';
                                if( !empty( $sub_title ) ) {
                                    echo '<div class="kfw-inter-img-sub-title">';
                                        echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
                                    echo '</div>';
                                }
                                if( !empty( $title ) ) {
                                    echo '<div class="kfw-inter-img-title" data-text="'. esc_html( $title ).'">';
                                        echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                                    echo '</div>';
                                }                                
                            echo '</div>';
                        }
                echo '</div>';

                /**
                 * Main Image : Only Visible in Responsive
                 */
                echo '<div class="kfw-elementor-inter-img-responsive-image-item">';
                    if( !empty( $item['main_image']['url'] ) ) {
                        $image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
                        $image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

                        $image_title = $this->_get_image_title( $item['main_image'] );
                        $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                        $image_alt = $this->_get_image_alt( $item['main_image'] );
                        $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                        $image_attr = $this->get_repeater_setting_key( 'responsive-image-item', 'items', $index );

                        $this->add_render_attribute( $image_attr, [
                            'class' => 'kfw-elementor-inter-img-image',
                            'alt'   => esc_attr( $image_alt ),
                            'title' => esc_attr( $image_title ),
                            'src'   => esc_url( $image_src ),
                        ]);

                        echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                    }
                echo '</div>';

            echo '</div>';

        endforeach;
    echo '</div>';

    /**
     * Images Section
     */
    echo '<div class="kfw-inter-img-section-wrap kfw-img-section-wrap">';
        foreach( $items as $index => $item ):
            $accordion_item = $this->get_repeater_setting_key( 'accordion_img_item', 'items', $index );
            $this->add_render_attribute( $accordion_item, [
                'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class'   => array_filter([
                    'kfw-elementor-inter-img-item',
                    'kfw-elementor-inter-img-image-item',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $accordion_item ).'>';
                if( !empty( $item['main_image']['url'] ) ) {
                    $image_src = $this->_get_image_src( $item['main_image']['id'], 'image_size', $settings );
                    $image_src = empty($image_src) ? $item['main_image']['url'] : $image_src;

                    $image_title = $this->_get_image_title( $item['main_image'] );
                    $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

                    $image_alt = $this->_get_image_alt( $item['main_image'] );
                    $image_alt = empty( $image_alt ) ? $image_title : $image_title;

                    $image_attr = $this->get_repeater_setting_key( 'image-item', 'items', $index );

                    $this->add_render_attribute( $image_attr, [
                        'class' => 'kfw-elementor-inter-img-image',
                        'alt'   => esc_attr( $image_alt ),
                        'title' => esc_attr( $image_title ),
                        'src'   => esc_url( $image_src ),
                    ]);

                    echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
                }
            echo '</div>';
        endforeach;
    echo '</div>';

echo '</div>';