<?php
/**
 * Widget Template : Lordicon Icon Box
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-lordicon-icon-box-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-lordicon-icon-box-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Icon Wrap
     */
    $this->add_render_attribute( 'icon-wrap', [
        'class' => [
            'kfw-ele-widget-lordicon-icon-box-lordicon-wrap',
            'kfw-ele-widget-lordicon-icon-box-'.esc_attr( $settings['source_type'] ) . '-type'
        ]
    ]);
    echo '<div '.$this->get_render_attribute_string( 'icon-wrap' ).'>';

        /**
         * Icon
         */
        $this->add_render_attribute( 'kfw-elementor-lordicon-wrap', [
            'class' => 'kfw-elementor-lordicon-wrap',
        ]);
        echo '<div '.$this->get_render_attribute_string( 'kfw-elementor-lordicon-wrap' ).'>';

            $src = '';
            if( $settings['source_type'] === 'media' ) {
                $src = !empty( $settings['source_media']['url'] ) ? $settings['source_media']['url'] : '';
            } else if( $settings['source_type'] === 'external' ) {
                $src = !empty( $settings['source_external']['url'] ) ? $settings['source_external']['url'] : '';
            }

            if( !empty( $src ) ) {
                $this->add_render_attribute( 'lordicon', 'class', 'kfw-elementor-lordicon' );

                $this->add_render_attribute( 'lordicon', 'src', $src );
                $this->add_render_attribute( 'lordicon', 'trigger', $settings['trigger'] );

                if( $settings['target'] === 'widget' ) {
                    $this->add_render_attribute( 'lordicon', 'target', '.kfw-ele-widget-lordicon-icon-box-main' );
                } else if( $settings['target'] === 'column' ) {
                    $this->add_render_attribute( 'lordicon', 'target', '.elementor-column' );
                } else if( $settings['target'] === 'section' ) {
                    $this->add_render_attribute( 'lordicon', 'target', '.elementor-section' );
                } else if( $settings['target'] === 'custom' && !empty($settings['custom_target']) ) {
                    $this->add_render_attribute( 'lordicon', 'target', $settings['custom_target'] );
                }

                $stroke = !empty( $settings['media_stroke']['size'] ) ?  $settings['media_stroke']['size']: 45;
                $this->add_render_attribute( 'lordicon', 'stroke', $stroke );

                /**
                 * Colors
                 */
                $colors = '';
                $colors .= !empty( $settings['primary_color'] ) ? 'primary:'.$settings['primary_color'].',': '';
                $colors .= !empty( $settings['secondary_color'] ) ? 'secondary:'.$settings['secondary_color'].',': '';
                $colors .= !empty( $settings['tertiary_color'] ) ? 'tertiary:'.$settings['tertiary_color'].',': '';
                $colors .= !empty( $settings['quaternary_color'] ) ? 'quaternary:'.$settings['quaternary_color'].',': '';
                $colors .= !empty( $settings['quinary_color'] ) ? 'quinary:'.$settings['quinary_color'].',': '';
                $colors .= !empty( $settings['senary_color'] ) ? 'senary:'.$settings['senary_color'].',': '';
                if( !empty( $colors ) ) {
                    $this->add_render_attribute( 'lordicon', 'colors', $colors );
                }

                echo '<lord-icon '. $this->get_render_attribute_string( 'lordicon' ) .'>';
                echo '</lord-icon>';
            }
        echo '</div>';
    echo '</div>';

    /**
     * Content Wrap
     */
    $this->add_render_attribute( 'content-wrap', [
        'class' => [ 'kfw-ele-widget-lordicon-icon-box-content-wrap' ],
    ]);
    echo '<div '.$this->get_render_attribute_string( 'content-wrap' ).'>';
        /**
         * Title
         */
        $this->_title( $settings );

        /**
         * Sub Title
         */
        $this->_sub_title( $settings );


        /**
         * Description
         */
        $this->_description( $settings );

        /**
         * Button
         */
        $this->_button( $settings );
    echo '</div>';

echo '</div>';