<?php
/**
 * Widget Template : Lottie Icon Box
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-lottie-icon-box-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-lottie-icon-box-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Icon Wrap
     */
    $this->add_render_attribute( 'icon-wrap', [
        'class' => [
            'kfw-ele-widget-lottie-icon-box-lottie-wrap',
            'kfw-ele-widget-lottie-icon-box-'.esc_attr( $settings['source_type'] ) . '-type'
        ]
    ]);
    echo '<div '.$this->get_render_attribute_string( 'icon-wrap' ).'>';
        /**
         * Icon
         */
        $this->add_render_attribute( 'kfw-elementor-lottie-wrap', [
            'class' => 'kfw-elementor-lottie-wrap',
        ]);
        echo '<div '.$this->get_render_attribute_string( 'kfw-elementor-lottie-wrap' ).'>';

            $this->add_render_attribute( 'kfw-elementor-lottie-inner-wrap', [
                'id'            => 'kfw-elementor-lottie-wrap-'. esc_attr( $this->get_id() ),
                'class'         => 'kfw-elementor-lottie-inner',
                'data-settings' => $this->_generate_setting_json( $settings ),
            ]);
            echo '<div '.$this->get_render_attribute_string( 'kfw-elementor-lottie-inner-wrap' ).'></div>';

        echo '</div>';
    echo '</div>';

    /**
     * Content Wrap
     */
    $this->add_render_attribute( 'content-wrap', [
        'class' => [ 'kfw-ele-widget-lottie-icon-box-content-wrap' ],
    ]);
    echo '<div '.$this->get_render_attribute_string( 'content-wrap' ).'>';
        /**
         * Title
         */
        $this->_title( $settings );

        /**
         * Sub Title
         */
        $this->_sub_title( $settings );


        /**
         * Description
         */
        $this->_description( $settings );

        /**
         * Button
         */
        $this->_button( $settings );
    echo '</div>';

echo '</div>';