<?php
/**
 * Widget Template : Mailchimp Plus
 */

$api_key     = '';
$audience_id = '';
$settings    = $this->get_settings();

$this->add_render_attribute( 'main', [
    'id'            => 'kfw-ele-widget-mailchimp-'.esc_attr( $this->get_id() ),
    'class'         => [ 'kfw-ele-widget-mailchimp-main', 'kfw-ele-widget-mailchimp-plus-main' ],
    'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $api_type = $settings['api_type'];
    if( $api_type === 'settings' ) {
        $api_key     = kinfw_onnat_theme_options()->kinfw_get_option( 'mailchimp_api_key' );
        $audience_id = kinfw_onnat_theme_options()->kinfw_get_option( 'mailchimp_audience_id' );

        /**
         * Warning Message
         */
        if( empty( $api_key ) || empty( $audience_id ) ) {
            $this->_message( esc_html__('To utilize this element, set your MailChimp API key and Audience ID within the theme settings panel.', 'onnat-extra' ) );
        } else {
            $this->_layout();
        }

    } else if( $api_type === 'widget' ) {
        $api_key     = $settings['api_key'];
        $audience_id = $settings['audience_id'];

        /**
         * Warning Message
         */
        if( empty( $api_key ) || empty( $audience_id ) ) {
            $this->_message( esc_html__('To utilize this element, set your MailChimp API key and Audience ID.', 'onnat-extra' ) );
        } else {
            $this->_layout();
        }

    }

    echo '<div class="kinfw-notices-wrapper"></div>';

echo '</div>';