<?php
/**
 * Widget Template : Marquee Text
 */
$settings = $this->get_settings();
$link_to  = $settings['link_to'];

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-marquee-txt-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-marquee-txt-main'],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $items = array_filter(  $settings['items'] );
    if( !empty( $items )) {

        /**
         * Main List
         */
            $this->add_render_attribute( 'marquee-list', [
                'class' => array_filter( [
                    'kfw-ele-marquee-list',
                ])
            ]);
            echo '<div '. $this->get_render_attribute_string( 'marquee-list' ) .'>';

                foreach( $items as $index => $item ) {

                    $link = array_filter( $item['link'] );

                    /**
                     * Icon
                     */
                        if( $item['icon_type'] == 'global' ) {

                            if( $settings['icon_type'] !== 'blank' ) {

                                if( isset( $link['url'] ) && ('icon' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<div class="kfw-ele-marquee-icon-wrap kfw-ele-marquee-linked-icon-wrap" '. $link .'>';
                                } else {
                                    echo "<div class='kfw-ele-marquee-icon-wrap'>";
                                }

                                    if( $settings['icon_type'] === 'icon' ) {
                                        $this->_render_icon( $settings['icon'] );
                                    } else if( $settings['icon_type'] === 'image' ) {
                                        $this->_render_img( $settings, $item['_id'] );
                                    } else if( $settings['icon_type'] === 'input' ) {
                                        $this->_render_input( $settings['input'] );
                                    }

                                echo '</div>';
                            }
                        } else {
                            if( $item['icon_type'] !== 'blank' ) {
                                if( isset( $link['url'] ) && ('icon' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<div class="kfw-ele-marquee-icon-wrap kfw-ele-marquee-linked-icon-wrap" '. $link .'>';
                                } else {
                                    echo "<div class='kfw-ele-marquee-icon-wrap'>";
                                }

                                    if( $item['icon_type'] === 'icon' ) {
                                        $this->_render_icon( $item['icon'] );
                                    } else if( $item['icon_type'] === 'image' ) {
                                        $this->_render_img( $item, $item['_id'] );
                                    } else if( $item['icon_type'] === 'input' ) {
                                        $this->_render_input( $item['input'] );
                                    }

                                echo '</div>';
                            }
                        }

                    /**
                     * Content
                     */
                        echo "<div class='kfw-ele-marquee-content-wrap'>";

                            if( !empty( $item['title'] ) ) {

                                if( isset( $link['url'] ) && ( 'title' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<span class="kfw-ele-marquee-title kfw-ele-marquee-linked-title" data-text="'. esc_html( $item["title"] ).'" '. $link_attr.'>';
                                        echo esc_html( $item["title"] );
                                    echo "</span>";

                                } else {
                                    echo "<span class='kfw-ele-marquee-title' data-text='".esc_html( $item["title"] )."'>";
                                        echo esc_html( $item["title"] );
                                    echo "</span>";
                                }

                            }

                        echo '</div>';

                }

            echo '</div>';

        /**
         * Duplicate List
         */
            $this->add_render_attribute( 'marquee-list-hidden', [
                'aria-hidden' => 'true',
                'class'       => array_filter( [
                    'kfw-ele-marquee-list',
                ])
            ]);
            echo '<div '. $this->get_render_attribute_string( 'marquee-list-hidden' ) .'>';

                foreach( $items as $index => $item ) {

                    $link = array_filter( $item['link'] );

                    /**
                     * Icon
                     */
                        if( $item['icon_type'] == 'global' ) {
                            if( $settings['icon_type'] !== 'blank' ) {
                                if( isset( $link['url'] ) && ('icon' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<div class="kfw-ele-marquee-icon-wrap kfw-ele-marquee-linked-icon-wrap" '. $link .'>';
                                } else {
                                    echo "<div class='kfw-ele-marquee-icon-wrap'>";
                                }

                                if( $settings['icon_type'] === 'icon' ) {
                                    $this->_render_icon( $settings['icon'] );
                                } else if( $settings['icon_type'] === 'image' ) {
                                    $this->_render_img( $settings, $item['_id']. '_x' );
                                } else if( $settings['icon_type'] === 'input' ) {
                                    $this->_render_input( $settings['input'] );
                                }

                                echo '</div>';
                            }
                        } else {
                            if( $item['icon_type'] !== 'blank' ) {
                                if( isset( $link['url'] ) && ('icon' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<div class="kfw-ele-marquee-icon-wrap kfw-ele-marquee-linked-icon-wrap" '. $link .'>';
                                } else {
                                    echo "<div class='kfw-ele-marquee-icon-wrap'>";
                                }

                                    if( $item['icon_type'] === 'icon' ) {
                                        $this->_render_icon( $item['icon'] );
                                    } else if( $item['icon_type'] === 'image' ) {
                                        $this->_render_img( $item, $item['_id'] );
                                    } else if( $item['icon_type'] === 'input' ) {
                                        $this->_render_input( $item['input'] );
                                    }

                                echo '</div>';
                            }
                        }

                    /**
                     * Content
                     */

                        echo "<div class='kfw-ele-marquee-content-wrap'>";

                            if( !empty( $item['title'] ) ) {

                                if( isset( $link['url'] ) && ( 'title' === $link_to || 'all' === $link_to ) ) {
                                    $target    = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';
                                    $link_attr = sprintf('onclick="window.open(\'%s\', \'%s\');"', esc_url($link['url']), $target);

                                    echo '<span class="kfw-ele-marquee-title kfw-ele-marquee-linked-title" data-text="'. esc_html( $item["title"] ).'" '. $link_attr.'>';
                                        echo esc_html( $item["title"] );
                                    echo "</span>";

                                } else {
                                    echo "<span class='kfw-ele-marquee-title' data-text='".esc_html( $item["title"] )."'>";
                                        echo esc_html( $item["title"] );
                                    echo "</span>";
                                }

                            }

                        echo '</div>';

                }

            echo '</div>';

    }

echo '</div>';