<?php
/**
 * Widget Template : Progress Bar Circle
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-widget-pbar-circle-'.esc_attr( $this->get_id() ),
	'class' => ['kfw-ele-widget-pbar-circle-wrapper',],
] );

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

	/**
	 * Title
	 */
		if( $settings['title_pos'] === 'yes' ) {
			$this->_bar_title();
		}

	/**
	 * Bar
	 */
		$this->add_render_attribute( 'bar', [
			'class'         => array_filter([
				'kfw-ele-widget-pbar-circle',
				$settings['bar_style']
			]),
			'data-settings' => $this->_generate_setting_json(),
		]);

		echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';

			$this->add_render_attribute( 'content-wrapper', [
				'class' => array_filter([
					'kfw-ele-widget-pbar-circle-content-wrapper'
				])
			]);
			echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
				/**
				 * Top Content
				 */
				if( $settings['top_type'] !== 'blank' ) {
					if( $settings['top_type'] === 'text' && !empty( $settings['top_text']) ) {
						$this->add_render_attribute( 'before', [
							'class' => array_filter([
								'kfw-ele-widget-pbar-circle-content-before'
							])
						]);

						echo '<div '.$this->get_render_attribute_string( 'before' ).'>';
							echo esc_html( $settings['top_text'] );
						echo '</div>';
					} else if( $settings['top_type'] === 'icon' && !empty( $settings['top_icon']) ) {
						$this->add_render_attribute( 'before', [
							'class' => array_filter([
								'kfw-ele-widget-pbar-circle-content-before',
								'kfw-ele-widget-pbar-circle-content-before-icon'
							])
						]);
						echo '<div '.$this->get_render_attribute_string( 'before' ).'>';
							$this->_render_icons( $settings['top_icon'] );
						echo '</div>';
					}
				}

				/**
				 * Middle Content
				 */
					if( $settings['middle_type'] !== 'blank' ) {

						if( $settings['middle_type'] === 'text' && !empty( $settings['middle_text']) ) {
							$this->add_render_attribute( 'middle', [
								'class' => array_filter([
									'kfw-ele-widget-pbar-circle-content-middle'
								])
							]);

							echo '<div '.$this->get_render_attribute_string( 'middle' ).'>';
								echo esc_html( $settings['middle_text'] );
							echo '</div>';

						} else if( $settings['middle_type'] === 'val' ) {
							$this->add_render_attribute( 'info', [
								'class' => array_filter([
									'kfw-ele-widget-pbar-circle-info'
								])
							]);

							echo '<div '.$this->get_render_attribute_string( 'info' ).'>';
								echo '<div class="kfw-ele-widget-pbar-circle-number"></div>';

								if( $settings['bar_val_type'] === 'percent' ) {
									if( $settings['show'] === 'yes' ) {
										echo '<div class="kfw-ele-widget-pbar-circle-number-meta"> <span> % </span> </div>';
									} else {
										echo '<div class="kfw-ele-widget-pbar-circle-number-meta"> <span> / 100 </span> </div>';
									}
								} else if( $settings['bar_val_type'] === 'absolute' ) {
									if( $settings['show'] === 'yes' ) {
										echo '<div class="kfw-ele-widget-pbar-circle-number-meta"> <span> % </span> </div>';
									} else {
										echo '<div class="kfw-ele-widget-pbar-circle-number-meta"> <span> / '. $settings['abs_max_val'] .' </span> </div>';
									}
								}
							echo '</div>';
						}
					}

				/**
				 * Bottom Content
				 */
				if( $settings['bottom_type'] !== 'blank' ) {
					if( $settings['bottom_type'] === 'text' && !empty( $settings['bottom_text']) ) {
						$this->add_render_attribute( 'after', [
							'class' => array_filter([
								'kfw-ele-widget-pbar-circle-content-after'
							])
						]);

						echo '<div '.$this->get_render_attribute_string( 'after' ).'>';
							echo esc_html( $settings['bottom_text'] );
						echo '</div>';
					} else if( $settings['bottom_type'] === 'icon' && !empty( $settings['bottom_icon']) ) {
						$this->add_render_attribute( 'after', [
							'class' => array_filter([
								'kfw-ele-widget-pbar-circle-content-after',
								'kfw-ele-widget-pbar-circle-content-after-icon'
							])
						]);
						echo '<div '.$this->get_render_attribute_string( 'after' ).'>';
							$this->_render_icons( $settings['bottom_icon'] );
						echo '</div>';
					}
				}

			echo '</div>';

		echo '</div>';

	/**
	 * Title
	 */
		if( $settings['title_pos'] !== 'yes' ) {
			$this->_bar_title();
		}

echo '</div>';