<?php
/**
 * Widget Template : Progress Bar Line
 */

$settings = $this->get_settings();
$bar_top  = 0;

$this->add_render_attribute( 'wrapper', [
	'id'            => 'kfw-ele-widget-pbar-line-'.esc_attr( $this->get_id() ),
	'class'         => [
		'kfw-ele-widget-pbar-line-wrapper',
		( $settings['name_pos'] === 'yes' ) ? 'kfw-ele-widget-pbar-content-position-top' : 'kfw-ele-widget-pbar-content-position-bottom',
	],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

if( isset( $settings['sbar_height']['size'] ) || isset( $settings['pbar_height']['size'] ) ) {
	$bar_top = ( $settings['sbar_height']['size'] - $settings['pbar_height']['size'] ) / 2;
}

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

	$bar_type = $settings['bar_type'];

	if( $bar_type === 'on-the-right-style' ) {

		if( $settings['name_pos'] === 'yes' ) {
			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
					$this->_bar_info();
				echo '</div>';

			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';
					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);
					echo '<div '.$this->get_render_attribute_string( 'bar' ).'></div>';

				echo '</div>';
		} else {
			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';
					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);
					echo '<div '.$this->get_render_attribute_string( 'bar' ).'></div>';
				echo '</div>';

			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
					$this->_bar_info();
				echo '</div>';
		}
	}

	if( $bar_type === 'show-as-tooltip-style' || $bar_type === 'show-as-tooltip-alt-style' ) {
		if( $settings['name_pos'] === 'yes' ) {
			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';

			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info();
					echo '</div>';

				echo '</div>';

		} else {
			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info();
					echo '</div>';

				echo '</div>';

			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';
		}
	}

	if( $bar_type === 'inside-the-bar-style' ) {

		if( $settings['name_pos'] === 'yes' ) {
			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';

			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info();
					echo '</div>';

				echo '</div>';

		} else {
			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info();
					echo '</div>';

				echo '</div>';

			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';
		}
	}

	if( $bar_type === 'inside-the-bar-centered-style' ) {

		if( $settings['name_pos'] === 'yes' ) {
			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';

			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info( 'kfw-txt-center' );
					echo '</div>';

				echo '</div>';

		} else {
			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'>';
						$this->_bar_info( 'kfw-txt-center' );
					echo '</div>';

				echo '</div>';

			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';
		}
	}

	if( $bar_type === 'inside-the-empty-bar-style' ) {
		if( $settings['name_pos'] === 'yes' ) {
			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';

			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'></div>';
					$this->_bar_info();

				echo '</div>';

		} else {
			/**
			 * Bar Section
			 */
				$this->add_render_attribute( 'bar-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-bar-wrapper'
					]),
				]);

				echo '<div '.$this->get_render_attribute_string( 'bar-wrapper' ).'>';

					$this->add_render_attribute( 'bar', [
						'class' => array_filter([
							'kfw-ele-widget-pbar-line-bar',
							$settings['bar_style'],
							$settings['anim_type']
						]),
						'style' => 'top:'. $bar_top .'px'
					]);

					echo '<div '.$this->get_render_attribute_string( 'bar' ).'></div>';
					$this->_bar_info();

				echo '</div>';

			/**
			 * Title Section
			 */
				$this->add_render_attribute( 'content-wrapper', [
					'class' => array_filter([
						'kfw-ele-widget-pbar-line-content-wrapper'
					])
				]);

				echo '<div '.$this->get_render_attribute_string( 'content-wrapper' ).'>';
					$this->_bar_title();
				echo '</div>';
		}		
	}

echo '</div>';