<?php
/**
 * Widget Template : Site Logo
 */
$settings = $this->get_settings();
$logo     = [];

if( 'logo' === $settings['source'] ) {
    $logo = kinfw_onnat_theme_options()->kinfw_get_option( 'logo' );
} else if( 'logo_alt' === $settings['source'] ) {
    $logo = kinfw_onnat_theme_options()->kinfw_get_option( 'logo_alt' );
} else if( 'sticky' === $settings['source'] ) {
    $logo = kinfw_onnat_theme_options()->kinfw_get_option( 'logo_sticky' );
} else if( 'mobile' === $settings['source'] ) {
    $logo = kinfw_onnat_theme_options()->kinfw_get_option( 'logo_mobile' );
} else if( 'custom' === $settings['source'] ) {
    $logo = $settings["image"];
}

if( is_array( $logo ) && isset( $logo['url'] ) ) {

    if( 'custom' === $settings['source'] ) {
        $image_src = $this->_get_image_src( $logo['id'], 'image_size', $settings );
        $image_src = empty($image_src) ? $logo['url'] : $image_src;

        $image_title = $this->_get_image_title( $logo );
        $image_title = empty( $image_title ) ? $this->get_title() : $image_title;

        $image_alt = $this->_get_image_alt( $logo );
        $image_alt = empty( $image_alt ) ? $image_title : $image_title;

    } else {
        $image_src   = $logo['url'];
        $image_title = $logo['title'];
        $image_alt   = $logo['alt'];
    }

    $img = sprintf( '
        <img src="%1$s" alt="%2$s" title="%3$s" class="%4$s"/>',
        esc_url( $image_src ),
        esc_attr( $image_alt ),
        esc_attr( $image_title ),
        $this->_is_svg( $logo['url'] ) ? 'kinfw-switch-svg' : '',
    );

    if( 'site-link' === $settings['link_type'] ) {

        $this->add_render_attribute( 'main', 'class', [ 'kfw-ele-widget-site-logo-main', 'kfw-ele-widget-site-logo-has-link' ]  );

        echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

        printf( '<a href="%1$s"> %2$s </a>', esc_url( home_url( '/' ) ), $img );

        echo '</div>';

    } else if( 'custom-link' === $settings['link_type'] ) {

        $link = $settings['custom_link'];

        if( isset( $link['url'] ) && !empty( $link['url'] ) ) {

            $target = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';

            $this->add_render_attribute( 'main', 'class', [ 'kfw-ele-widget-site-logo-main', 'kfw-ele-widget-site-logo-has-link' ]  );

            echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

            printf( '<a href="%1$s" target="%2$s"> %3$s </a>', esc_url( $link['url'] ), esc_attr( $target ), $img );

            echo '</div>';

        } else {

            $this->add_render_attribute( 'main', 'class', [ 'kfw-ele-widget-site-logo-main' ]  );

            echo '<div '.$this->get_render_attribute_string( 'main' ).'>'. $img . '</div>';

        }

    }

}