<?php
/**
 * Widget Template : Testimonial Carousel
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'            => 'kfw-ele-widget-testimonial-carousel-'.esc_attr( $this->get_id() ),
	'class'         => [
		'kfw-ele-widget-testimonial-carousel-main',
		$settings['layout']
	],
	'data-settings' => $this->_generate_setting_json( $settings ),
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	$this->add_render_attribute( 'swiper', [
		'data-id' => 'kfw-js-swiper-'.esc_attr( $this->get_id() ),
		'class'   => array_filter( [
			'kfw-js-swiper-'.esc_attr( $this->get_id() ),
			esc_attr( $settings['layout'] ) . '-wrap',
			'kfw-swiper',
			'swiper',
			'swiper-container',
		])
	]);
	echo '<div '. $this->get_render_attribute_string( 'swiper' ) .'>';

		$this->add_render_attribute( 'list', [
			'class' => array_filter( [
				'kfw-ele-testimonial-carousel-list',
				'swiper-wrapper'
			])
		]);
		echo '<div '. $this->get_render_attribute_string( 'list' ) .'>';
			if( 'kfw-testimonial-style-1' === $settings['layout'] ) {
				$this->_style_1( $items, $settings );
			} else if( 'kfw-testimonial-style-2' === $settings['layout'] ) {
				$this->_style_1( $items, $settings );
			} else if( 'kfw-testimonial-style-3' === $settings['layout'] ) {
				$this->_style_3( $items, $settings );
			} else if( 'kfw-testimonial-style-4' === $settings['layout'] ) {
                $this->_style_4( $items, $settings );
			}
		echo '</div>';

	echo '</div>';

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] !== 'custom' ) {

        /**
         * Navigation
         */
        $this->add_render_attribute( 'navEl', [
            'class' => array_filter( [
                'kfw-testimonial-carousel-nav-wrap',
                esc_attr( $settings['layout'] ) . '-nav-wrap',
                'kfw-testimonial-carousel-nav-pos-'. $settings['arrow_position'],
                $settings['mobile_arrows'] === 'yes' ? 'hide-on-sm hide-on-xs' : ''
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'navEl' ).'>';

            $this->add_render_attribute( 'prevEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-prev',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'prevEl' ).'>';
                $this->_render_icon( $settings['right_arrow'] );
            echo '</div>';

            $this->add_render_attribute( 'nextEl', [
                'class' => array_filter( [
                    'kfw-swiper-nav-next',
                    'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next'
                ] )
            ] );
            echo '<div '.$this->get_render_attribute_string( 'nextEl' ).'>';
                $this->_render_icon( $settings['left_arrow'] );
            echo '</div>';

        echo '</div>';
    }

    if( $settings['dots'] === 'yes' ) {

        /**
         * Pagination
         */
        $this->add_render_attribute( 'pagination', [
            'class' => array_filter( [
                'kfw-swiper-pagination',
                'kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination'
            ] )
        ] );
        echo '<div '.$this->get_render_attribute_string( 'pagination' ).'></div>';
    }

    if( $settings['arrows'] === 'yes' && $settings['arrow_position'] === 'custom' ) {
        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-next %2$s for Next Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );

        $this->_message(
            sprintf(
                esc_html__('Use this class %1$s kfw-js-swiper-nav kfw-js-swiper-%3$s-nav-prev %2$s for Prev Nav Element.','onnat-extra'),
                sprintf( '<strong class="kfw-js-clickable" title="%1$s">', esc_html__('Click to Copy') ),
                '</strong>',
                esc_attr( $this->get_id() )
            )
        );
    }

echo '</div>';