<?php
/**
 * Widget Template : Text Highlighter
 */
$settings  = $this->get_settings();
$sub_title = trim( $settings['sub_title'] );

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-text-highlighter-'.esc_attr( $this->get_id() ),
    'class' => [ 'kfw-ele-widget-text-highlighter-main' ],
]);

$link  = array_filter( $settings['title_link'] );
if( isset( $link['url'] ) ) {

    $mode   = $this->_is_editor_mode();
    $target = ( !empty( $link['is_external'] ) ) ? '_blank' : '_self';

    $this->add_render_attribute( 'main', 'class', 'kfw-ele-widget-text-highlighter-linked' );

    if( !$mode ) {
        $this->add_render_attribute( 'main', 'onclick', 'window.open("'. esc_url( $link['url'] ) .'", "'.$target.'")' );
    }
}

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Sub Title at Top
     */
    if( !empty( $sub_title ) && 'top' === $settings['sub_title_pos'] ) {
        $this->_sub_title( $settings );
    }

    $tag = $this->_title_tag( $settings['title_tag'] );

    printf( '<div class="kfw-ele-widget-text-highlighter-title-wrap"> <%1$s>', $tag );

        /**
         * Primary
         */
        if( !empty( $settings['primary'] ) ) {
            $this->add_render_attribute( 'primary', 'class', 'kfw-elementor-text-highlighter-primary-text' );

            if( 'primary' == $settings['highlight_ele']) {
                echo '<span class="kfw-elementor-text-highlighter-wrap">';
                $this->add_render_attribute( 'primary', 'class', 'kfw-elementor-text-highlighter-text' );
            } else {
                $this->add_render_attribute( 'primary', 'class', 'kfw-elementor-text-highlighter-plain-text' );
            }

            printf(' <span %1$s>%2$s</span> ', $this->get_render_attribute_string( 'primary' ), $settings['primary'] );

            if( 'primary' == $settings['highlight_ele']) {
                echo '</span>';
            }
        }

        /**
         * Secondary
         */
        if( !empty( $settings['secondary'] ) ) {
            $this->add_render_attribute( 'secondary', 'class', 'kfw-elementor-text-highlighter-secondary-text' );

            if( 'secondary' == $settings['highlight_ele']) {
                echo '<span class="kfw-elementor-text-highlighter-wrap">';
                $this->add_render_attribute( 'secondary', 'class', 'kfw-elementor-text-highlighter-text' );
            } else {
                $this->add_render_attribute( 'secondary', 'class', 'kfw-elementor-text-highlighter-plain-text' );
            }

            printf(' <span %1$s>%2$s</span> ', $this->get_render_attribute_string( 'secondary' ), $settings['secondary'] );

            if( 'secondary' == $settings['highlight_ele']) {
                echo '</span>';
            }
        }

        /**
         * Tertiary
         */
        if( !empty( $settings['tertiary'] ) ) {
            $this->add_render_attribute( 'tertiary', 'class', 'kfw-elementor-text-highlighter-tertiary-text' );

            if( 'tertiary' == $settings['highlight_ele']) {
                echo '<span class="kfw-elementor-text-highlighter-wrap">';
                $this->add_render_attribute( 'tertiary', 'class', 'kfw-elementor-text-highlighter-text' );
            } else {
                $this->add_render_attribute( 'tertiary', 'class', 'kfw-elementor-text-highlighter-plain-text' );
            }

            printf(' <span %1$s>%2$s</span> ', $this->get_render_attribute_string( 'tertiary' ), $settings['tertiary'] );

            if( 'tertiary' == $settings['highlight_ele']) {
                echo '</span>';
            }
        }

    printf( '</%1$s> </div>', $tag );

    /**
     * Sub Title at Bottom
     */
    if( !empty( $sub_title ) && 'bottom' === $settings['sub_title_pos'] ) {
        $this->_sub_title( $settings );
    }

echo '</div>';