<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_Blog_Single_Post_Author_Box extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-blog-single-post-author-box';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Post Author Box', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_blog_post_look_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-user-circle-o';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'blog', 'post', 'single', 'author', 'box' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/blog-single-post-author-box';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-blog-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/blog-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );

    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-blog-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_main_section();
		$this->_register_wrap_settings();
		$this->_register_avatar_style_section();
		$this->_register_name_style_section();
		$this->_register_desc_style_section();
	}

	public function _register_main_section() {
		$this->start_controls_section( 'section_main', [
			'label' => esc_html__( 'Author Info', 'onnat-extra' )
		]);
			$this->add_control( 'type', [
				'label'   => esc_html__( 'Type', 'onnat-extra' ),
				'type'    => KFCM::CHOOSE,
				'options' => [
					'post-author' => [
						'title' => esc_html__('Post Author', 'onnat-extra'),
						'icon'  => 'eicon-user-circle-o',
					],
					'custom'      => [
						'title' => esc_html__('Custom', 'onnat-extra'),
						'icon'  => 'eicon-person',
					],
				],
				'default' => 'post-author',
				'toggle'  => false,
			]);
            $this->add_control( 'avatar_size', [
				'label'      => esc_html__('Avatar Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ '' ],
				'range'      => [
                    'px' => [
						'min'  => 50,
						'max'  => 500,
						'step' => 1,
                    ],
                ],
            ]);
			$condition = [
				'type' => 'custom'
			];
			$this->add_control( 'heading_custom_avatar', [
				'label'     => esc_html__( 'Custom Author', 'onnat-extra' ),
				'type'      => KFCM::HEADING,
				'condition' => $condition,
			]);
            $this->add_control( 'hr_custom_avatar', [
				'type'      => KFCM::DIVIDER,
				'condition' => $condition,
			]);
			$this->add_control( 'avatar', [
				'label'     => esc_html__( 'Avatar', 'onnat-extra' ),
				'type'      => KFCM::MEDIA,
				'default'   => [ 'url' => KFE_CONST_URL .'libraries/elementor/assets/images/avatar.png' ],
				'condition' => $condition,
				'dynamic'   => [ 'active' => true ],
			]);
			$this->add_control( 'name', [
				'label'       => esc_html__( 'Name', 'onnat-extra' ),
				'type'        => KFCM::TEXT,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'default'     => esc_html__( 'Author Name' , 'onnat-extra' ),
				'condition'   => $condition,
			]);
			$this->add_control( 'link', [
				'label'       => esc_html__( 'Link', 'onnat-extra' ),
				'type'        => KFCM::URL,
				'placeholder' => 'https://your-link.com',
				'default'     => [
					'url'               => '',
					'is_external'       => false,
					'nofollow'          => false,
					'custom_attributes' => false,
				],
				'condition'   => [
					'type'  => 'custom',
					'name!' => '',
				],
			]);
			$this->add_control('description',[
				'label'       => esc_html__( 'Description', 'onnat-extra' ),
				'type'        => KFCM::TEXTAREA,
				'dynamic'     => [ 'active' => true, ],
				'placeholder' => esc_html__( 'Enter Description', 'onnat-extra' ),
				'default'     => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', 'onnat-extra' ),
				'label_block' => true,
				'condition'   => $condition,
			]);
		$this->end_controls_section();
	}

	public function _register_wrap_settings() {
		$this->start_controls_section( 'section_wrap_style', [
			'label' => esc_html__( 'Wrapper', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'wrap_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'wrap_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'           => 'wrap_bg',
				'types'          => ['classic', 'gradient'],
				'exclude'        => [ 'image'],
				'fields_options' => [
					'background' => [ 'default' => 'classic' ],
					'color'      => [ 'default' => '' ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-author-box',
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'wrap_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-author-box',
			]);
			$this->add_responsive_control( 'wrap_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'wrap_box_shadow',
				'exclude'   => [ 'box_shadow_position', ],
				'selector'  => '{{WRAPPER}} .kinfw-author-box',
			]);		
		$this->end_controls_section();
	}

	public function _register_avatar_style_section() {
		$this->start_controls_section( 'section_avatar_style', [
			'label' => esc_html__( 'Avatar', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'avatar_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfw-author-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'avatar_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfw-author-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'avatar_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-author-box .kinfw-author-img img',
			]);
			$this->add_responsive_control( 'avatar_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kinfw-author-box .kinfw-author-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'       => 'btn_box_shadow',
				'selector'   => '{{WRAPPER}} .kinfw-author-box .kinfw-author-img img',
			]);

		$this->end_controls_section();
	}

	public function _register_name_style_section() {
		$this->start_controls_section( 'section_name_style', [
			'label' => esc_html__( 'Name', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'name_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfw-author-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'name_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfw-author-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_group_control( KFGCT::get_type(), [
				'name'        => 'name_typo',
				'description' => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'    => '{{WRAPPER}} .kinfw-author-box .kinfw-author-name',
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'name_txt_shadow',
				'selector' => '{{WRAPPER}} .kinfw-author-box .kinfw-author-name',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'name_txt_stroke',
				'selector' => '{{WRAPPER}} .kinfw-author-box .kinfw-author-name',
			]);
			$this->add_control( 'name_color_settings', [
				'label'        => esc_html__('Colors', 'onnat-extra'),
				'type'         => KFCM::POPOVER_TOGGLE,
				'return_value' => 'yes',
			]);
			$this->start_popover();
				$this->add_control( 'name_color', [
					'label'     => esc_html__('Normal Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => [
					'{{WRAPPER}} .kinfw-author-box .kinfw-author-name, {{WRAPPER}} .kinfw-author-box .kinfw-author-name a' => 'color:{{VALUE}};',
					],
				]);
				$this->add_control( 'name_hover_color', [
					'label'     => esc_html__('Hover Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => [
						'{{WRAPPER}} .kinfw-author-box .kinfw-author-name:hover, {{WRAPPER}} .kinfw-author-box .kinfw-author-name a:hover' => 'color:{{VALUE}}',
					],
				]);
			$this->end_popover();
		$this->end_controls_section();
	}

	public function _register_desc_style_section() {
		$this->start_controls_section( 'section_desc_style', [
			'label' => esc_html__( 'Description', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'desc_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'desc_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_group_control( KFGCT::get_type(), [
				'name'        => 'desc_typo',
				'description' => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'    => '{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p',
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'     => 'desc_txt_shadow',
				'selector' => '{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'     => 'desc_txt_stroke',
				'selector' => '{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p',
			]);
			$this->add_control( 'desc_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
				'{{WRAPPER}} .kinfw-author-box .kinfo-author-desc p' => 'color:{{VALUE}};',
				],
			]);
		$this->end_controls_section();
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-blog-single-post-author-box");
		include $render;
    }
}