<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_CPT_Project_Navigation extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-project-post-navigation';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Project Post Navigation', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_single_project_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-post-navigation';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'project', 'post', 'single', 'navigation' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-project-post-navigation';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

        wp_register_style( 'kfw-cpt-project-single',
            KFE_CONST_URL . 'libraries/elementor/assets/css/cpt-project-single' . KFE_CONST_DEBUG_SUFFIX . '.css',
            [],
            KFE_CONST_VERSION
        );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-cpt-project-single' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [  ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_settings_section();
		$this->_register_style_section();
	}

	public function _register_settings_section() {
		$this->start_controls_section( 'settings_section', [
			'label' => esc_html__( 'Settings', 'onnat-extra' )
		]);
			$this->add_control('type',[
				'label'   => esc_html__( 'Post Nav Type', 'onnat-extra' ),
				'type'    => KFCM::CHOOSE,
				'toggle'  => false,
				'default' => 'type-1',
				'options' => [
					'type-1' => [
						'title' => esc_html__('Type 1', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-1-icon'
					],
					'type-2' => [
						'title' => esc_html__('Type 2', 'onnat-extra'),
						'icon'  => 'kfw-ctrl-icon kfw-ctrl-type-2-icon'
					],
				],
			]);
            $this->add_control('hr0', [
				'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('prev_post_settings',[
                'label' => esc_html__( 'PREV POST', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
            ]);
				$this->add_control('prev_post_title',[
					'label'       => esc_html__( 'Title', 'onnat-extra' ),
					'type'        => KFCM::TEXT,
					'dynamic'     => [ 'active' => true ],
					'default'     => esc_html__( 'Prev Project' , 'onnat-extra' ),
					'label_block' => true,
				]);
				$this->add_control('prev_post_icon_type',[
					'label'   => esc_html__( 'Icon Type', 'onnat-extra' ),
					'type'    => KFCM::CHOOSE,
					'options' => [
						'blank' => [
							'title' => esc_html__('Blank', 'onnat-extra'),
							'icon'  => '',
						],
						'icon'  => [
							'title' => esc_html__('Icon', 'onnat-extra'),
							'icon'  => 'eicon-plus-circle-o',
						],
						'image' => [
							'title' => esc_html__('Image', 'onnat-extra'),
							'icon'  => 'eicon-image',
						],
					],
					'default' => 'blank',
					'toggle'  => false
				]);
				$this->add_control( 'prev_post_icon', [
					'label'       => esc_html__( 'Icon', 'onnat-extra' ),
					'type'        => KFCM::ICONS,
					'default'     => [
						'value'   => 'fas fa-heart',
						'library' => 'fa-solid',
					],
					'recommended' => [
						'fa-solid'   => [
							'chevron-down',
							'angle-down',
							'angle-double-down',
							'caret-down',
							'caret-square-down',
						],
						'fa-regular' => [
							'caret-square-down',
						],
					],
					'skin'        => 'inline',
					'condition'   => [
						'prev_post_icon_type' => 'icon'
					],
				]);
				$this->add_control( 'prev_post_image', [
					'label'     => esc_html__( 'Image', 'onnat-extra' ),
					'type'      => KFCM::MEDIA,
					'dynamic'   => [ 'active' => true ],
					'condition' => [
						'prev_post_icon_type' => 'image'
					],
				]);
            $this->add_control('hr1', [
				'type' => KFCM::DIVIDER,
            ]);
            $this->add_control('next_post_settings',[
                'label' => esc_html__( 'NEXT POST', 'onnat-extra' ),
				'type'  => KFCM::HEADING,
            ]);
				$this->add_control('next_post_title',[
					'label'       => esc_html__( 'Title', 'onnat-extra' ),
					'type'        => KFCM::TEXT,
					'dynamic'     => [ 'active' => true ],
					'default'     => esc_html__( 'Next Project' , 'onnat-extra' ),
					'label_block' => true,
				]);
				$this->add_control('next_post_icon_type',[
					'label'   => esc_html__( 'Icon Type', 'onnat-extra' ),
					'type'    => KFCM::CHOOSE,
					'options' => [
						'blank' => [
							'title' => esc_html__('Blank', 'onnat-extra'),
							'icon'  => '',
						],
						'icon'  => [
							'title' => esc_html__('Icon', 'onnat-extra'),
							'icon'  => 'eicon-plus-circle-o',
						],
						'image' => [
							'title' => esc_html__('Image', 'onnat-extra'),
							'icon'  => 'eicon-image',
						],
					],
					'default' => 'blank',
					'toggle'  => false
				]);
				$this->add_control( 'next_post_icon', [
					'label'       => esc_html__( 'Icon', 'onnat-extra' ),
					'type'        => KFCM::ICONS,
					'default'     => [
						'value'   => 'fas fa-heart',
						'library' => 'fa-solid',
					],
					'recommended' => [
						'fa-solid'   => [
							'chevron-down',
							'angle-down',
							'angle-double-down',
							'caret-down',
							'caret-square-down',
						],
						'fa-regular' => [
							'caret-square-down',
						],
					],
					'skin'        => 'inline',
					'condition'   => [
						'next_post_icon_type' => 'icon'
					],
				]);
				$this->add_control( 'next_post_image', [
					'label'     => esc_html__( 'Image', 'onnat-extra' ),
					'type'      => KFCM::MEDIA,
					'dynamic'   => [ 'active' => true ],
					'condition' => [
						'next_post_icon_type' => 'image'
					],
				]);
		$this->end_controls_section();
	}

	public function _register_style_section() {
		$this->start_controls_section( 'next_prev_style_section', [
			'label' => esc_html__( 'Next / Prev', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->nav_wrap_settings();
			$this->nav_txt_settings();
			$this->nav_icon_settings();
			$this->nav_post_title_settings();
		$this->end_controls_section();
	}

	public function nav_wrap_settings() {
		$condition = [
			'type' => 'type-2'
		];
		$this->add_control('wrap_hr_1', [
			'type'      => KFCM::DIVIDER,
			'condition' => $condition,
		]);
		$this->add_control('nav_wrapper_settings',[
			'label'     => esc_html__( 'WRAPPER', 'onnat-extra' ),
			'type'      => KFCM::HEADING,
			'condition' => $condition,
		]);
		$this->add_control('wrap_hr_2', [
			'type'      => KFCM::DIVIDER,
			'condition' => $condition,
		]);
		$this->add_responsive_control( 'nav_wrapper_size', [
			'label'      => esc_html__('Size', 'onnat-extra' ),
			'type'       => KFCM::SLIDER,
			'size_units' => [ 'px' ],
			'condition'  => $condition,
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 500,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};'
			],
		]);
		$this->start_controls_tabs( 'nav_wrapper_customize_tabs' );
			$this->start_controls_tab( 'nav_wrapper_normal_state', [
				'label'     => esc_html__( 'Normal', 'onnat-extra' ),
				'condition' => $condition,
			]);
				$this->add_group_control( KFGCBG::get_type(), [
					'name'           => 'nav_wrapper_bg',
					'types'          => ['classic', 'gradient'],
					'exclude'        => [ 'image'],
					'condition'      => $condition,
					'fields_options' => [
						'background' => [ 'default' => 'classic' ],
						'color'      => [ 'default' => '' ],
					],
					'selector'       => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a',
				]);
				$this->add_group_control( KFGCBR::get_type(), [
					'name'           => 'nav_wrapper_border',
					'fields_options' => [
						'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
						'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
					],
					'condition'      => $condition,
					'selector'       => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a',
				]);
				$this->add_responsive_control( 'nav_wrapper_border_radius', [
					'label'      => esc_html__('Border Radius', 'onnat-extra' ),
					'type'       => KFCM::DIMENSIONS,
					'condition'  => $condition,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]);
				$this->add_group_control( KFGCBS::get_type(), [
					'name'      => 'nav_wrapper_box_shadow',
					'exclude'   => [ 'box_shadow_position', ],
					'condition' => $condition,
					'selector'  => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a',
				]);
			$this->end_controls_tab();
			$this->start_controls_tab( 'nav_wrapper_hover_state', [
				'label'     => esc_html__( 'Hover', 'onnat-extra' ),
				'condition' => $condition,
			]);
				$this->add_group_control( KFGCBG::get_type(), [
					'name'           => 'nav_wrapper_h_bg',
					'types'          => ['classic', 'gradient'],
					'exclude'        => [ 'image'],
					'condition'      => $condition,
					'fields_options' => [
						'background' => [ 'default' => 'classic' ],
						'color'      => [ 'default' => '' ],
					],
					'selector'       => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a:hover',
				]);			
				$this->add_group_control( KFGCBR::get_type(), [
					'name'           => 'nav_wrapper_h_border',
					'fields_options' => [
						'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
						'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
					],
					'condition'      => $condition,
					'selector'       => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a:hover',
				]);
				$this->add_responsive_control( 'nav_wrapper_h_border_radius', [
					'label'      => esc_html__('Border Radius', 'onnat-extra' ),
					'type'       => KFCM::DIMENSIONS,
					'condition'  => $condition,
					'size_units' => [ 'px', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]);
				$this->add_group_control( KFGCBS::get_type(), [
					'name'      => 'nav_wrapper_h_box_shadow',
					'exclude'   => [ 'box_shadow_position', ],
					'condition' => $condition,
					'selector'  => '{{WRAPPER}} .kfw-post-nav-type-2 .kinfw-post-nav > div > a:hover',
				]);			
			$this->end_controls_tab();			
		$this->end_controls_tabs();
	}

	public function nav_txt_settings() {
		$this->add_control('hr3_0', [
			'type' => KFCM::DIVIDER,
		]);
		$this->add_control('nav_txt_settings',[
			'label' => esc_html__( 'TEXT', 'onnat-extra' ),
			'type'  => KFCM::HEADING,
		]);
		$this->add_control('hr3', [
			'type' => KFCM::DIVIDER,
		]);
		$this->add_group_control(KFGCT::get_type(), [
			'name'      => 'nav_txt_typo',
			'label'     => esc_html__( 'Typography', 'onnat-extra' ),
			'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt',
		]);
		$this->add_responsive_control( 'nav_txt_margin', [
			'label'      => esc_html__('Margin', 'onnat-extra' ),
			'type'       => KFCM::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			]
		]);
		$this->add_responsive_control( 'nav_txt_padding', [
			'label'      => esc_html__('Padding', 'onnat-extra' ),
			'type'       => KFCM::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			]
		]);
		$this->start_controls_tabs( 'nav_txt_customize_tabs' );
			$this->start_controls_tab( 'nav_txt_normal_state', [
				'label' => esc_html__( 'Normal', 'onnat-extra' ),
			]);
				$this->add_control( 'nav_txt_color', [
					'label'     => esc_html__('Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => ['{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt' => 'color: {{VALUE}};' ],
				]);
				$this->add_group_control( KFGCTS::get_type(), [
					'name'      => 'nav_txt_txt_shadow',
					'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt',
				]);
				$this->add_group_control( KFGCTST::get_type(), [
					'name'      => 'nav_txt_txt_stroke',
					'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-txt',
				]);
			$this->end_controls_tab();
			$this->start_controls_tab( 'nav_txt_hover_state', [
				'label' => esc_html__( 'Hover', 'onnat-extra' ),
			]);
				$this->add_control( 'nav_txt_h_color', [
					'label'     => esc_html__('Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'selectors' => ['{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-txt' => 'color: {{VALUE}};' ],
				]);
				$this->add_group_control( KFGCTS::get_type(), [
					'name'      => 'nav_txt_h_txt_shadow',
					'selector'  => '{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-txt',
				]);
				$this->add_group_control( KFGCTST::get_type(), [
					'name'      => 'nav_txt_h_txt_stroke',
					'selector'  => '{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-txt',
				]);
			$this->end_controls_tab();
		$this->end_controls_tabs();	
	}

	public function nav_icon_settings() {
		$this->add_control('hr4_b', [
			'type' => KFCM::DIVIDER,
		]);
		$this->add_control('nav_txt_icon_settings',[
			'label' => esc_html__( 'ICON', 'onnat-extra' ),
			'type'  => KFCM::HEADING,
		]);
		$this->add_control('hr4', [
			'type' => KFCM::DIVIDER,
		]);
		$this->add_responsive_control( 'nav_txt_icon_margin', [
			'label'      => esc_html__('Margin', 'onnat-extra' ),
			'type'       => KFCM::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			],
		]);
		$this->add_responsive_control( 'nav_txt_icon_padding', [
			'label'      => esc_html__('Padding', 'onnat-extra' ),
			'type'       => KFCM::DIMENSIONS,
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
			],
		]);
		$this->add_responsive_control( 'nav_txt_icon_type_size', [
			'label'      => esc_html__('Icon Size', 'onnat-extra' ),
			'type'       => KFCM::SLIDER,
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 200,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap' => 'font-size: {{SIZE}}{{UNIT}};'
			],
		]);
		$this->add_responsive_control( 'nav_txt_img_type_size', [
			'label'      => esc_html__('Image Size', 'onnat-extra' ),
			'type'       => KFCM::SLIDER,
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 5,
					'max' => 500,
				],
			],
			'selectors'  => [
				'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap img' => 'max-width:{{SIZE}}px;'
			],
		]);
		$this->add_control( 'nav_txt_icon_color_settings', [
			'label'        => esc_html__('Icon Colors', 'onnat-extra'),
			'type'         => KFCM::POPOVER_TOGGLE,
			'return_value' => 'yes',
		]);
		$this->start_popover();
			$this->add_control( 'nav_txt_icon_type_color', [
				'label'     => esc_html__('Normal Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap i' => 'color:{{VALUE}};',
					'{{WRAPPER}} .kinfw-post-nav .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
				],
			]);
			$this->add_control( 'nav_txt_icon_type_h_color', [
				'label'     => esc_html__('Hover Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-post-nav > div > a:hover .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap i' => 'color:{{VALUE}};',
					'{{WRAPPER}} .kinfw-post-nav > div > a:hover .kfw-post-nav-icon-wrap .kfw-elementor-icon-wrap svg' => 'fill:{{VALUE}};',
				],
			]);
		$this->end_popover();
	}

	public function nav_post_title_settings() {
		$condition = [
			'type' => 'type-1'
		];

		$this->add_control('hr5_b', [
			'type'      => KFCM::DIVIDER,
			'condition' => $condition,
		]);
		$this->add_control('nav_post_title_settings',[
			'label'     => esc_html__( 'POST TITLE', 'onnat-extra' ),
			'type'      => KFCM::HEADING,
			'condition' => $condition,
		]);
		$this->add_control('hr5', [
			'type'      => KFCM::DIVIDER,
			'condition' => $condition,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'nav_post_title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title',
				'condition' => $condition,
			]);
			$this->add_responsive_control( 'nav_post_title_margin', [
				'label'      => esc_html__('Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->add_responsive_control( 'nav_post_title_padding', [
				'label'      => esc_html__('Padding', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'condition'  => $condition,
				'selectors'  => [
					'{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]);
			$this->start_controls_tabs( 'nav_post_title_customize_tabs' );
				$this->start_controls_tab( 'nav_post_title_normal_state', [
					'label'     => esc_html__( 'Normal', 'onnat-extra' ),
					'condition' => $condition,
				]);
					$this->add_control( 'nav_post_title_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title' => 'color: {{VALUE}};' ],
						'condition' => $condition,
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'nav_post_title_txt_shadow',
						'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title',
						'condition' => $condition,
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'nav_post_title_txt_stroke',
						'selector'  => '{{WRAPPER}} .kinfw-post-nav .kinfw-post-nav-title',
						'condition' => $condition,
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'nav_post_title_hover_state', [
					'label'     => esc_html__( 'Hover', 'onnat-extra' ),
					'condition' => $condition,
				]);
					$this->add_control( 'nav_post_title_h_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => ['{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-title' => 'color: {{VALUE}};' ],
						'condition' => $condition,
					]);
					$this->add_group_control( KFGCTS::get_type(), [
						'name'      => 'nav_post_title_h_txt_shadow',
						'selector'  => '{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-title',
						'condition' => $condition,
					]);
					$this->add_group_control( KFGCTST::get_type(), [
						'name'      => 'nav_post_title_h_txt_stroke',
						'selector'  => '{{WRAPPER}} .kinfw-post-nav > div > a:hover .kinfw-post-nav-title',
						'condition' => $condition,
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();		
	}	

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
            echo '<div class="kfw-post-nav-icon-wrap kfw-post-nav-icon-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
                echo '</span>';
            echo '</div>';
		}
    }

    public function _render_img( $settings = [] ) {
        if( !empty( $settings['url'] ) ) {
            $image_src = $settings['url'];

			$image_title = $this->_get_image_title( $settings );
			$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

			$image_alt = $this->_get_image_alt( $settings );
			$image_alt = empty( $image_alt ) ? $image_title : $image_title;

            echo '<div class="kfw-post-nav-icon-wrap kfw-post-nav-image-type">';
                echo '<span class="kfw-elementor-icon-wrap">';
                    echo '<img alt="'. esc_attr( $image_alt ) .'" title="'. esc_attr( $image_title ) .'" src="'. esc_url( $image_src ) .'"/>';
                echo '</span>';
            echo '</div>';
        }
    }

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-project-navigation");
		include $render;
    }
}