<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;

use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_CPT_Team_Member_Grid extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-team-member-grid';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Team Member Grid', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_theme_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-container-grid kfw-cpt-team-member-grid';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'team', 'member', 'grid' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-team-member-grid';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_social_links_section();
		$this->_register_settings_section();
		$this->_register_image_style_section();
		$this->_register_content_wrap_style_section();
		$this->_register_title_style_section();
		$this->_register_role_style_section();
		$this->_register_social_style_section();
	}

    public function _register_items_section() {
		$members = $this->_team_members();

		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Team Members', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control( 'items', [
				'type'        => KFCM::REPEATER,
				'fields'      => [
					[
						'name'        => 'member',
						'label'       => esc_html__( 'Member', 'onnat-extra' ),
						'type'        => KFCM::SELECT2,
						'multiple'    => false,
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
						'options'     => $members,
						'default'     => ''
					]
				],
				'title_field' => "<# let labels = ".json_encode( $members )."; let label = labels[member]; #>{{{ label }}}",
				'default'     => [],
			]);
		$this->end_controls_section();
	}

	public function _register_social_links_section() {
		$social_links = [
			'facebook'  => esc_html__( 'Facebook', 'onnat-extra' ),
			'linkedin'  => esc_html__( 'LinkedIn', 'onnat-extra' ),
			'twitter'   => esc_html__( 'Twitter', 'onnat-extra' ),
			'youtube'   => esc_html__( 'YouTube', 'onnat-extra' ),
			'instagram' => esc_html__( 'Instagram', 'onnat-extra' ),
			'pinterest' => esc_html__( 'Pinterest', 'onnat-extra' ),
			'flickr'    => esc_html__( 'Flickr', 'onnat-extra' ),
			'xing'      => esc_html__( 'Xing', 'onnat-extra' ),
		];

		$this->start_controls_section( 'section_links', [
			'label' => esc_html__( 'Social Links', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control( 'socials', [
				'type'         => KFCM::REPEATER,
				'item_actions' => [
					'add' => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'fields'       => [
					[
						'name'        => 'social',
						'label'       => '',
						'type'        => KFCM::SELECT,
						'classes'     => 'elementor-control-type-hidden',
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
						'options'     => $social_links,
						'default'     => '',
					],
					[
						'name'         => 'status',
						'label'        => esc_html__( 'Enable it?', 'onnat-extra' ),
						'type'         => KFCM::SWITCHER,
						'dynamic'      => [ 'active' => true ],
						'return_value' => 'yes',
						'default'      => 'yes',
					],
				],
				'title_field'  => "<# let labels = ".json_encode( $social_links )."; let label = labels[social]; let s = ( status === 'yes' ) ? 'Enabled' : 'Disabled'; #> {{{ label }}} - {{{ s }}}",
				'default'      => [
					[ 'social' => 'facebook', 'status' => 'yes' ],
					[ 'social' => 'linkedin', 'status' => 'yes' ],
					[ 'social' => 'twitter', 'status' => 'yes' ],
					[ 'social' => 'youtube', 'status' => 'no' ],
					[ 'social' => 'instagram', 'status' => 'no' ],
					[ 'social' => 'pinterest', 'status' => 'no' ],
					[ 'social' => 'flickr', 'status' => 'no' ],
					[ 'social' => 'xing', 'status' => 'no' ],
				],
			]);
		$this->end_controls_section();
	}

	public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control('layout', [
				'label'   => esc_html__( 'Layout', 'onnat-extra' ),
				'type'    => KFCM::CHOOSE,
				'options' => [
					'kinfw-team-member-grid-style-1' => [
						'title' => esc_html__('Grid Style 1', 'onnat-extra' ),
						'icon'  => 'eicon-gallery-grid'
					],
					'kinfw-team-member-grid-style-2' => [
						'title' => esc_html__('Grid Style 2', 'onnat-extra' ),
						'icon'  => 'eicon-posts-grid'
					],
					'kinfw-team-member-grid-style-3' => [
						'title' => esc_html__('Grid Style 3', 'onnat-extra' ),
						'icon'  => 'eicon-person'
					],
					'kinfw-team-member-grid-style-4' => [
						'title' => esc_html__('Grid Style 4', 'onnat-extra' ),
						'icon'  => 'eicon-hypster'
					],
					'kinfw-team-member-grid-style-5' => [
						'title' => esc_html__('Grid Style 5', 'onnat-extra' ),
						'icon'  => 'eicon-user-circle-o'
					],
				],
				'default' => 'kinfw-team-member-grid-style-4',
				'toggle'  => false
			]);
			$this->add_responsive_control('style-4-min-height',[
				'label'     => esc_html__( 'Min Height', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'     => [
					'px' => [
						'min'  => 100,
						'max'  => 1000,
						'step' => 10,
					]
				],				
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4' => 'min-height:{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-4'
				],
			]);
			$this->add_responsive_control('cols', [
				'label'          => esc_html__( 'Columns', 'onnat-extra' ),
				'type'           => KFCM::CHOOSE,
				'options'        => [
					'1' => [ 'title' => esc_html__('1 Column', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-icon' ],
					'2' => [ 'title' => esc_html__('2 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon' ],
					'3' => [ 'title' => esc_html__('3 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-3-icon' ],
					'4' => [ 'title' => esc_html__('4 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-4-icon' ],
				],
				'devices'        => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'selectors'      => [
					'{{WRAPPER}} .kfw-ele-widget-cpt-team-member-grid-main' => 'display: grid; grid-template-columns: repeat({{SIZE}}, minmax(0, 1fr));',
				],
				'toggle'         => false
			]);
			$this->add_responsive_control('col_gap',[
				'label'     => esc_html__( 'Column Gap', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'   => [
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-cpt-team-member-grid-main' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]);
			$this->add_responsive_control('row_gap',[
				'label'     => esc_html__( 'Row Gap', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'   => [ 'size' => 20,],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-cpt-team-member-grid-main' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
				],
			]);
		$this->end_controls_section();
	}

	public function _register_image_style_section() {
		$this->start_controls_section( 'section_image_style', [
			'label' => esc_html__( 'Image', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control('style-4-image-max-height',[
				'label'     => esc_html__( 'Max Height', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'     => [
					'px' => [
						'min'  => 100,
						'max'  => 1000,
						'step' => 10,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4 .kinfw-team-member-image-wrap' => 'max-height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4:hover .kinfw-team-member-image-wrap' => 'max-height: 1000px;',
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-4'
				],
			]);		
			$this->add_group_control( KFGCBG::get_type(), [
				'name'     => 'image_bg',
				'label'    => esc_html__('Background', 'onnat-extra' ),
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'           => 'image_overlay_bg',
				'fields_options' => [
					'background' => [
						'label' => esc_html__('Background Overlay', 'onnat-extra' ),
					],
				],
				'types'          => [ 'classic', 'gradient' ],
				'exclude'        => [ 'image' ],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-5 .kinfw-team-member-image-wrap:before',
				'condition'      => [
					'layout' => 'kinfw-team-member-grid-style-5'
				],
			]);			
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'image_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
			$this->add_responsive_control( 'image_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kinfw-team-member-image-wrap, {{WRAPPER}} .kinfw-team-member-image-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'image_box_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
            $this->add_responsive_control( 'image_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-image-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'image_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-image-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
	}

	public function _register_content_wrap_style_section() {
		$this->start_controls_section( 'section_wrap_style', [
			'label' => esc_html__( 'Info Wrapper', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'     => 'wrap_bg',
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'      => 'wrap_hover_bg',
				'fields_options' => [
					'background' => [ 'label' => _x( 'Hover Background Type', 'Border Control', 'onnat-extra' ) ],
				],
				'types'     => [ 'classic', 'gradient' ],
				'exclude'   => [ 'image' ],
				'selector'  => '{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-team-member-content-wrap:before',
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);
            $this->add_control('accordion_hr0', [
                'type' => KFCM::DIVIDER,
            ]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'wrap_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
			$this->add_responsive_control( 'wrap_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'wrap_box_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
            $this->add_responsive_control( 'wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
	}

	public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'color: {{VALUE}};'
				],
			]);
			$this->add_control( 'title_h_color', [
				'label'     => esc_html__('Hover Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item:hover .kinfw-team-member-content-wrap h6 a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);			
			$this->add_group_control( KFGCTS::get_type(), [
				'name'      => 'title_txt_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'      => 'title_txt_stroke',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
		$this->end_controls_section();
	}

	public function _register_role_style_section() {
		$this->start_controls_section( 'section_role_style', [
			'label' => esc_html__( 'Role', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'role_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
            $this->add_responsive_control( 'role_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'role_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'role_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-content-wrap p a' => 'color: {{VALUE}};'
				],
			]);
			$this->add_control( 'role_h_color', [
				'label'     => esc_html__('Hover Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item:hover .kinfw-team-member-content-wrap p a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'      => 'role_txt_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'      => 'role_txt_stroke',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
		$this->end_controls_section();
	}

	public function _register_social_style_section() {
		$this->start_controls_section( 'section_social_style', [
			'label' => esc_html__( 'Social Share', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'icon_size', [
				'label'      => esc_html__('Icon Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a:before' => 'font-size:{{SIZE}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control( 'size', [
				'label'      => esc_html__('Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a'                                                   => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-social-links li a:before'                                            => 'line-height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-2 .kinfw-social-links' => 'bottom: calc(-1 * ({{SIZE}}{{UNIT}}/2 + 5{{UNIT}}));',
				],
			]);
			$this->add_responsive_control('margin', [
				'label'      => esc_html__( 'Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);

			/**
			 * Style 3 : Settings
			 */
				$s3_condition = [
					'layout' => 'kinfw-team-member-grid-style-3',
				];
				$this->add_control('social_icon_handler_heading',[
					'label'     => esc_html__( 'ADDITIONAL STYLE 3 SETTINGS', 'onnat-extra' ),
					'type'      => KFCM::HEADING,
					'condition' => $s3_condition,
				]);
				$this->add_control( 'social_icon_handler_wrapper_color', [
					'label'     => esc_html__('Wrapper Background Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'condition' => $s3_condition,
					'selectors' => [
						'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper' => 'background-color: {{VALUE}}; color: {{VALUE}};'
					],
				]);
				$this->start_controls_tabs( 'social_icon_handler_customize_tabs', [
					'condition' => $s3_condition,
				] );
					$this->start_controls_tab( 'social_icon_handler_normal_state', [
						'label'     => esc_html__( 'Handler Normal', 'onnat-extra' ),
						'condition' => $s3_condition,
					]);
						$this->add_control( 'social_icon_handler_icon_color', [
							'label'     => esc_html__('Icon Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon .kinfw-icon' => 'color: {{VALUE}};'
							],
						]);
						$this->add_control( 'social_icon_handler_icon_bg_color', [
							'label'     => esc_html__('Icon BG Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon' => 'background-color: {{VALUE}};'
							],
						]);
						$this->add_control( 'social_icon_handler_icon_border_color', [
							'label'     => esc_html__('Icon Border Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon' => 'border-color: {{VALUE}};'
							],
						]);
					$this->end_controls_tab();
					$this->start_controls_tab( 'social_icon_handler_hover_state', [
						'label'     => esc_html__( 'Handler Hover', 'onnat-extra' ),
						'condition' => $s3_condition,
					]);
						$this->add_control( 'social_icon_handler_icon_h_color', [
							'label'     => esc_html__('Icon Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon .kinfw-icon' => 'color: {{VALUE}};'
							],
						]);
						$this->add_control( 'social_icon_handler_icon_h_bg_color', [
							'label'     => esc_html__('Icon BG Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon' => 'background-color: {{VALUE}};'
							],
						]);
						$this->add_control( 'social_icon_handler_icon_h_border_color', [
							'label'     => esc_html__('Icon Border Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'condition' => $s3_condition,
							'selectors' => [
								'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon' => 'border-color: {{VALUE}};'
							],
						]);					
					$this->end_controls_tab();					
				$this->end_controls_tabs();
				$this->add_control( 'social_icon_holder_wrapper_color', [
					'label'     => esc_html__('Social Icons Holder Background Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'condition' => $s3_condition,
					'separator' => 'before',
					'selectors' => [
						'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-links' => 'background-color: {{VALUE}};'
					],
				]);
				$this->add_control( 'social_icon_holder_border_color', [
					'label'     => esc_html__('Social Icons Holder Border Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'condition' => $s3_condition,
					'separator' => 'after',
					'selectors' => [
						'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-links' => 'border-color: {{VALUE}};'
					],
				]);
			/**
			 * Style 3 : Settings End
			 */

			$this->start_controls_tabs( 'customize_tabs' );
				$this->start_controls_tab( 'normal_state', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_responsive_control( 'border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'hover_state', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:hover:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'hover_bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'hover_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_responsive_control( 'hover_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _team_members() {
		$result = [ esc_html__( '-- Select --', 'onnat-extra' ) ];

		$posts = get_posts([
			'post_type'      => 'kinfw-team-member',
			'post_status'    => 'publish',
			'posts_per_page' => -1
		]);

		if ( ! empty( $posts ) && ! is_wp_error( $posts ) ) {
			foreach ( $posts as $item ) {
				$result[ $item->ID ] = $item->post_title;
			}
		}

		return $result;
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-team-member-grid");
		include $render;
    }
}