<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as KFWB;
use \Elementor\Controls_Manager as KFCM;

use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Background as KFGCBG;

class KFW_Mega_Menu extends KFWB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-mega-menu';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Mega Menu', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_header_footer_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-mega-menu kfw-mega-menu';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'menu', 'mega'];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/mega-menu';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'kfw-mega-menu',
			KFE_CONST_URL . 'libraries/elementor/assets/js/mega-menu' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-mega-menu',
			KFE_CONST_URL . 'libraries/elementor/assets/css/mega-menu' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return ['kfw-mega-menu'];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'kfw-mega-menu' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_menu_section();
		$this->_register_main_menu_style_section();
		$this->_register_sub_menu_style_section();
    }

	public function _register_menu_section() {
		$this->start_controls_section( 'section_menu', [
			'label' => esc_html__( 'Menu', 'onnat-extra' )
		]);

			$this->add_control( 'menu', [
				'label'       => esc_html__( 'Choose Menu', 'onnat-extra' ),
				'type'        => KFCM::SELECT,
				'options'     => kf_extra_plugin_elementor()->get_available_menus(),
				'default'     => 0,
				'description' => sprintf(
					esc_html__('Go to the %1$s to manage your menus.', 'onnat-extra'),
					sprintf('<a href="%1$s" target="_blank">%2$s</a>', admin_url('nav-menus.php'), esc_html_x( 'Menus screen', 'link text for WordPress Admin Menu Screen', 'onnat-extra' )  )
				),
			] );
		$this->end_controls_section();
	}

	public function _register_main_menu_style_section() {
		$this->start_controls_section( 'section_main_menu_style', [
			'label' => esc_html__( 'Main Menu', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_control('align',[
				'label'        => esc_html__( 'Alignment', 'onnat-extra' ),
				'type'         => KFCM::CHOOSE,
				'options'      => [
					'left'    => [
						'title' => esc_html__( 'Left', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'onnat-extra' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'toggle'       => false,
				'default'      => 'center',
				'prefix_class' => 'kfw-elementor-mega-menu-align-',
			]);
            $this->add_group_control(KFGCT::get_type(), [
                'name'     => 'main_menu_typo',
                'label'    => esc_html__( 'Typography', 'onnat-extra' ),
                'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li a',
            ]);
			$this->add_control( 'hr_0', [
				'type' => KFCM::DIVIDER,
			]);
			$this->start_controls_tabs( 'tabs_main_menu_item_style' );
				$this->start_controls_tab( 'tabs_main_menu_item_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'main_menu_item_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li a'   => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'main_menu_item_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image', ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li a,{{WRAPPER}}.kfw-elementor-mega-menu-align-justify .kfw-ele-widget-mega-menu-main .kinfw-main-nav'
                    ]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_main_menu_item_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'main_menu_item_hover_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li a:hover'   => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'main_menu_item_hover_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image', ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li a:hover',
                    ]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_main_menu_item_active', [
					'label' => esc_html__( 'Active', 'onnat-extra' ),
				]);
					$this->add_control( 'main_menu_item_active_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li.current-menu-item a' => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'main_menu_item_active_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image' ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul li.current-menu-item a',
                    ]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_control( 'hr_1', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_responsive_control( 'main_menu_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'main_menu_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'hr_2', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control('main_menu_label_heading',[
				'label'     => esc_html__( 'MENU LABEL', 'onnat-extra' ),
				'type'      => KFCM::HEADING,
			]);
			$this->add_control( 'main_menu_label_top_pos',[
				'label'      => esc_html__( 'Top Position', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav > ul > li > a .kinfw-menu-label' =>'top: {{SIZE}}{{UNIT}}'
				],
			]);
		$this->end_controls_section();
	}

	public function _register_sub_menu_style_section() {
		$this->start_controls_section( 'section_sub_menu_style', [
			'label' => esc_html__( 'Sub Menu', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'     => 'sub_menu_typo',
				'label'    => esc_html__( 'Typography', 'onnat-extra' ),
				'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a',
			]);
			$this->start_controls_tabs( 'tabs_sub_menu_item_style' );
				$this->start_controls_tab( 'tabs_sub_menu_item_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'sub_menu_item_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a'   => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'sub_menu_item_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image', ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a,{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu'
                    ]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_sub_menu_item_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'sub_menu_item_hover_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a:hover'   => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'sub_menu_item_hover_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image', ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a:hover',
                    ]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_sub_menu_item_active', [
					'label' => esc_html__( 'Active', 'onnat-extra' ),
				]);
					$this->add_control( 'sub_menu_item_active_color', [
						'label'     => esc_html__('Menu Item Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'default'   => '',
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li.current-menu-item a' => 'color:{{VALUE}};',
						],
					]);
                    $this->add_group_control( KFGCBG::get_type(), [
                        'name'     => 'sub_menu_item_active_bg',
                        'label'    => esc_html__('Background', 'onnat-extra' ),
                        'types'    => [ 'classic', 'gradient', 'image' ],
                        'exclude'  => [ 'video' ],
                        'selector' => '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li.current-menu-item a',
                    ]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
			$this->add_control( 'hr_3', [
				'type' => KFCM::DIVIDER,
			]);
            $this->add_responsive_control( 'sub_menu_wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'sub_menu_wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'hr_4', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control('smenu_label_heading',[
				'label'     => esc_html__( 'MENU LABEL', 'onnat-extra' ),
				'type'      => KFCM::HEADING,
			]);
			$this->add_control( 'smenu_label_top_pos',[
				'label'      => esc_html__( 'Top Position', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .kfw-ele-widget-mega-menu-main .kinfw-main-nav ul li > ul.sub-menu li a .kinfw-menu-label' =>'top: {{SIZE}}{{UNIT}}'
				],
			]);
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-mega-menu");
		include $render;
    }
}