<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extend_FontFlow_WP_Plugin' ) ) {

	/**
	 * Extends the FontFlow Custom Icons for Elementor
     * https://wordpress.org/plugins/fontflow-custom-icons-for-elementor
	 */
    class KinForce_Extend_FontFlow_WP_Plugin {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            if( !$this->check_requirement() ) {
                return;
            }

            add_filter( 'fontflow-filter/plugin/elementor/icons-list', [ $this, 'add_admin_icons_list' ], 999, 1 );
            $this->load_icons_lib();

        }

		/**
		 * Check whether basic provision reached.
		 */
		private function check_requirement() {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

            return is_plugin_active( 'fontflow-custom-icons-for-elementor/fontflow-custom-icons-for-elementor.php' ) ? true : false;
        }

        public function add_admin_icons_list( $icons_list ) {

            $images_url = KFE_CONST_URL . 'libraries/fontflow/assets/images/icon-provides/';

            /**
             * Add Onnat Icons set
             */
            $onnat_icons  = [
                'name'           => 'Onnat Icons',
                'author'         => 'KinForce',
                'author_url'     => 'https://kinforce.net/',
                'description'    => esc_html__( 'It comprises a selection of open-source icons integrated into our onnat theme.', 'onnat-extra' ),
                'db_option'      => 'fontflow_onnaticons',
                'action_url'     => 'javascript:void(0);',
                'image'          => $images_url . 'onnat.svg',
            ];

            $icons_list = array_merge(array($onnat_icons), $icons_list);

            /**
             * Add KinForce Icons set
             */
            $kinfw_icons  = [
                'name'           => 'KinForce Icons',
                'author'         => 'KinForce',
                'author_url'     => 'https://kinforce.net/',
                'description'    => esc_html__( 'It comprises a selection of open-source icons integrated into our theme.', 'onnat-extra' ),
                'db_option'      => 'fontflow_kinfwicons',
                'action_url'     => 'javascript:void(0);',
                'image'          => $images_url . 'kinforce.svg',
            ];

            $icons_list = array_merge(array($kinfw_icons), $icons_list);

            /**
             * Add Themify Icons set
             */
            $themify_icon = [
                'name'           => 'Themify',
                'author'         => 'Themify',
                'author_url'     => 'https://themify.me/themify-icons',
                'description'    => esc_html__( 'Themify Icons is a complete set of icons for use in web design and apps, consisting of 320+ pixel-perfect, hand-crafted icons that draw inspiration from Apple iOS 7.', 'onnat-extra' ),
                'learn_more_url' => 'https://themify.me/themify-icons',
                'db_option'      => 'fontflow_themifyicons',
                'action_url'     => 'javascript:void(0);',
                'image'          => $images_url . 'themify.svg',
            ];

            array_push( $icons_list, $themify_icon );

            return $icons_list;
        }

        public function load_icons_lib() {

            /**
             * Icons Lib
             */
                $icons_lib = [
                    [
                        'key'  => 'fontflow_themifyicons',
                        'file' => KFE_CONST_DIR . 'libraries/fontflow/class-themifyicons.php'
                    ],
                    [
                        'key'  => 'fontflow_kinfwicons',
                        'file' => KFE_CONST_DIR . 'libraries/fontflow/class-kinfwicons.php'
                    ],
                    [
                        'key'  => 'fontflow_onnaticons',
                        'file' => KFE_CONST_DIR . 'libraries/fontflow/class-onnaticons.php'
                    ],
                ];

			foreach( $icons_lib as $icon_lib ) {
				$option = get_option( $icon_lib['key'] );
				$file   = $icon_lib['file'];

				if( $option && file_exists( $file ) ) {
					require_once $file;
				}
			}

        }

    }

}

if( !function_exists( 'kf_extend_fontflow' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extend_fontflow() {

        return KinForce_Extend_FontFlow_WP_Plugin::get_instance();
    }
}

kf_extend_fontflow();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */