<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Blog_Post_Style' ) ) {

	/**
	 * Define the footer custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Blog_Post_Style {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        private $latest_post_id = 0;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            $this->latest_post_id = $this->_latest_post();

            add_action( 'init', [ $this, 'init' ] );
            add_action( 'admin_menu', [ $this, 'admin_menu' ] );
            add_filter( 'parent_file', [ $this, 'admin_parent_file' ] );

            add_filter('page_row_actions', [ $this, 'remove_view_link' ], 10, 2);

            add_filter( 'single_template', [ $this, 'load_template' ] );

        }

        public function _latest_post() {
            $latest_post = get_posts([
                'numberposts' => 1,
                'post_type'   => 'post',
                'post_status' => 'publish',
            ]);

            if ( !empty($latest_post) ) {
                return $latest_post[0]->ID;
            } else {
                return 0;
            }
        }        

        public function init() {

            $labels = [
                'name'               => __( 'Blog Post Styles', 'onnat-extra' ),
                'singular_name'      => __( 'Blog Post Style', 'onnat-extra' ),
                'menu_name'          => __( 'Blog Post Style', 'onnat-extra' ),
                'name_admin_bar'     => __( 'Blog Post Style', 'onnat-extra' ),
                'add_new'            => __( 'Add New', 'onnat-extra' ),
                'add_new_item'       => __( 'Add New Blog Post Style', 'onnat-extra' ),
                'new_item'           => __( 'New Template', 'onnat-extra' ),
                'edit_item'          => __( 'Edit Template', 'onnat-extra' ),
                'view_item'          => __( 'View Template', 'onnat-extra' ),
                'all_items'          => __( 'Blog Post Style', 'onnat-extra' ),
                'search_items'       => __( 'Search Templates', 'onnat-extra' ),
                'parent_item_colon'  => __( 'Parent Templates:', 'onnat-extra' ),
                'not_found'          => __( 'No Templates found.', 'onnat-extra' ),
                'not_found_in_trash' => __( 'No Templates found in Trash.', 'onnat-extra' ),
            ];

            $args   = [
                'label'               => esc_html__( 'Blog Post Style', 'onnat-extra' ),
                'labels'              => $labels,
                'supports'            => array( 'title', 'editor' ),
                'hierarchical'        => true,
                'public'              => true,
                'show_ui'             => true,
                'show_in_admin_bar'   => true,
                'show_in_menu'        => 'false',
                'show_in_nav_menus'   => false,
                'can_export'          => false,
                'has_archive'         => false,
                'exclude_from_search' => true,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                'show_in_rest'        => true
            ];

            register_post_type( 'kinfw-blog-post-look', $args );
        }

        public function admin_menu() {

            if( !current_user_can('edit_pages') ) {

                return;
            }

            add_submenu_page(
                ONNAT_CONST_SAN_THEME,
                esc_html__( 'Blog Post Styles', 'onnat-extra' ),
                esc_html__( 'Blog Post Styles', 'onnat-extra' ),
                'edit_pages',
                'edit.php?post_type=kinfw-blog-post-look',
                '',
                40
            );

            remove_meta_box( 'pageparentdiv', 'kinfw-blog-post-look', 'normal' );

        }

        public function admin_parent_file( $parent_file ) {

            global $submenu_file, $current_screen;

            if( $current_screen->post_type == "kinfw-blog-post-look" ) {

                $parent_file  = ONNAT_CONST_SAN_THEME;
                $submenu_file = 'edit.php?post_type=kinfw-blog-post-look';

            }

            return $parent_file;

        }

        public function remove_view_link( $actions, $post ) {

            if ( $post->post_type === 'kinfw-blog-post-look' ) {
                # unset($actions['view']);

                $actions['view'] = sprintf(
                    '<a href="%1$s" rel="bookmark" aria-label="%2$s" title="%2$s" target="_blank">%3$s</a>',
                    esc_url( add_query_arg( 'kfw-preview', $post->ID, get_permalink( $this->latest_post_id ) ) ),
                    esc_attr( sprintf( __( 'Blog Single Template &#8220;%s&#8221; Preview', 'onnat-extra' ), $post->post_title ) ),
                    esc_html__('Preview Template', 'onnat-extra' )
                );                
            }

            return $actions;

        }        

        public function load_template( $template ) {

            global $post;
            $type = $post->post_type;

            if ( 'kinfw-blog-post-look' === $type ) {

                $template = KFE_CONST_DIR . 'libraries/framework/single/single-kinfw-blog-post-style.php';

            }

            /**
             * To load Elementor in single post - when Elementor Layout selected for single blog post.
             */
            if( 'post' === $type && defined( 'ELEMENTOR_VERSION' ) ) {

                $post_id    = $post->ID;
                $meta       = get_post_meta( $post_id, ONNAT_CONST_THEME_POST_SETTINGS, true );
                $post_style = isset( $meta['post_style'] ) ? $meta['post_style'] : 'theme_post_style';

                $template_id = 0;

                if( 'theme_post_style' === $post_style ) {
                    $template_id = (int) kinfw_onnat_theme_options()->kinfw_get_option( 'single_post_style' );
                } else if ( 'custom_post_style' === $post_style ) {
                    $template_id = isset( $meta['custom_post_style'] ) ? (int) $meta['custom_post_style'] : 0;
                }

                if( $template_id ) {
                    $preview = \Elementor\Plugin::$instance->preview->is_preview_mode();
                    $editor  = \Elementor\Plugin::$instance->editor->is_edit_mode();

                    if( $preview || $editor ) {
                        $template = KFE_CONST_DIR . 'libraries/framework/single/single-blog-post.php';
                    }
                }

            }            

            return $template;
        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_blog_post_style' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_blog_post_style() {

        return KinForce_Extra_Plugin_CPT_Blog_Post_Style::get_instance();
    }
}

kf_extra_plugin_cpt_blog_post_style();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */