<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Project' ) ) {

	/**
	 * Define the project custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Project {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        private $latest_post_id = 0;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            $this->latest_post_id = $this->_latest_post();

            add_action( 'init', [ $this, 'init' ] );
            add_filter( 'enter_title_here', [ $this, 'post_type_title_placeholder' ], 10, 2 );
            add_action( 'admin_menu', [ $this, 'admin_menu' ] );
            add_filter( 'parent_file', [ $this, 'admin_parent_file' ] );
            add_filter( 'page_row_actions', [ $this, 'remove_view_link' ], 10, 2);
            add_filter( 'single_template', [ $this, 'load_template' ] );

            add_filter( 'template_include', [ $this, 'custom_template' ], 100 );

            add_filter( 'theme_kinfw-project_templates', [ $this, 'page_templates' ] );
            add_filter( 'kinfw-filter/theme/metabox/template/post-type', [ $this, 'add_template_metabox' ] );

            add_action( 'kinfw-action/theme/meta-boxes/our/cpt/loaded', [ $this, 'add_extra_metabox' ] );

        }

        public function _latest_post() {
            $latest_post = get_posts([
                'numberposts' => 1,
                'post_type'   => 'kinfw-project',
                'post_status' => 'publish',
            ]);

            if ( !empty($latest_post) ) {
                return $latest_post[0]->ID;
            } else {
                return 0;
            }
        }

        public function init() {

            /**
             * Register Custom Post Type
             */
            $project_cpt_slug   = 'kinfw-project';
            $project_group_slug = 'kinfw-project-category';

            $labels = [
                'name'                  => esc_html__( 'Projects', 'onnat-extra' ),
                'singular_name'         => esc_html__( 'Project', 'onnat-extra' ),
                'menu_name'             => esc_html__( 'Projects', 'onnat-extra' ),
                'name_admin_bar'        => esc_html__( 'Projects', 'onnat-extra' ),
                'add_new'               => esc_html__( 'Add New Project', 'onnat-extra' ),
                'add_new_item'          => esc_html__( 'Add New Project', 'onnat-extra' ),
                'new_item'              => esc_html__( 'New Template', 'onnat-extra' ),
                'edit_item'             => esc_html__( 'Edit Template', 'onnat-extra' ),
                'view_item'             => esc_html__( 'View Template', 'onnat-extra' ),
                'all_items'             => esc_html__( 'All Projects', 'onnat-extra' ),
                'search_items'          => esc_html__( 'Search Templates', 'onnat-extra' ),
                'parent_item_colon'     => esc_html__( 'Parent Templates:', 'onnat-extra' ),
                'not_found'             => esc_html__( 'No Templates found.', 'onnat-extra' ),
                'not_found_in_trash'    => esc_html__( 'No Templates found in Trash.', 'onnat-extra' ),
                'featured_image'        => esc_html__( 'Project Image', 'onnat-extra' ),
                'set_featured_image'    => esc_html__( 'Set Project Image', 'onnat-extra' ),
                'remove_featured_image' => esc_html__( 'Remove Project Image', 'onnat-extra' ),
                'use_featured_image'    => esc_html__( 'Use as Project Image', 'onnat-extra' ),
            ];

            $args   = [
                'label'               => esc_html__( 'Project', 'onnat-extra' ),
                'labels'              => $labels,
                'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes' ),
                'hierarchical'        => false,
                'public'              => true,
                'show_ui'             => true,
                'show_in_admin_bar'   => true,
                'show_in_menu'        => true,
                'show_in_nav_menus'   => true,
                'menu_icon'           => 'dashicons-portfolio',
                'can_export'          => false,
                'has_archive'         => false,
                'exclude_from_search' => false,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                'show_in_rest'        => true,
                'rewrite'             => [ 'slug' => esc_attr($project_cpt_slug) ],
            ];

            register_post_type( 'kinfw-project', $args );

            /**
             * Register Custom Taxonomy
             */
            $labels   = [
                'name'                       => _x( 'Project Categories', 'Taxonomy General Name', 'onnat-extra' ),
                'singular_name'              => _x( 'Project Category', 'Taxonomy Singular Name', 'onnat-extra' ),
                'menu_name'                  => __( 'Categories', 'onnat-extra' ),
                'all_items'                  => __( 'All Project Categories', 'onnat-extra' ),
                'parent_item'                => __( 'Parent Project Category', 'onnat-extra' ),
                'parent_item_colon'          => __( 'Parent Project Category:', 'onnat-extra' ),
                'new_item_name'              => __( 'New Project Category', 'onnat-extra' ),
                'add_new_item'               => __( 'Add New Project Category', 'onnat-extra' ),
                'edit_item'                  => __( 'Edit Project Category', 'onnat-extra' ),
                'update_item'                => __( 'Update Project Category', 'onnat-extra' ),
                'view_item'                  => __( 'View Project Category', 'onnat-extra' ),
                'separate_items_with_commas' => __( 'Separate items with commas', 'onnat-extra' ),
                'add_or_remove_items'        => __( 'Add or remove Project Categories', 'onnat-extra' ),
                'choose_from_most_used'      => __( 'Choose from the most used', 'onnat-extra' ),
                'popular_items'              => __( 'Popular Project Categories', 'onnat-extra' ),
                'search_items'               => __( 'Search Project Categories', 'onnat-extra' ),
                'not_found'                  => __( 'Not Found', 'onnat-extra' ),
                'no_terms'                   => __( 'No Project Categories', 'onnat-extra' ),
                'items_list'                 => __( 'Project Categories list', 'onnat-extra' ),
                'items_list_navigation'      => __( 'Project Categories list navigation', 'onnat-extra' ),
            ];

            $tax_args = [
                'labels'            => $labels,
                'hierarchical'      => true,
                'public'            => true,
                'show_ui'           => true,
                'show_admin_column' => true,
                'query_var'         => true,
                'rewrite'           => [ 'slug' => esc_attr($project_group_slug) ],
            ];

            register_taxonomy( 'kinfw-project-category', [ 'kinfw-project' ], $tax_args );

            /**
             * Template CPT
             */
            $labels = [
                'name'               => __( 'Project Styles', 'onnat-extra' ),
                'singular_name'      => __( 'Project Style', 'onnat-extra' ),
                'menu_name'          => __( 'Project Style', 'onnat-extra' ),
                'name_admin_bar'     => __( 'Project Style', 'onnat-extra' ),
                'add_new'            => __( 'Add New', 'onnat-extra' ),
                'add_new_item'       => __( 'Add New Project Style', 'onnat-extra' ),
                'new_item'           => __( 'New Template', 'onnat-extra' ),
                'edit_item'          => __( 'Edit Template', 'onnat-extra' ),
                'view_item'          => __( 'View Template', 'onnat-extra' ),
                'all_items'          => __( 'Project Style', 'onnat-extra' ),
                'search_items'       => __( 'Search Templates', 'onnat-extra' ),
                'parent_item_colon'  => __( 'Parent Templates:', 'onnat-extra' ),
                'not_found'          => __( 'No Templates found.', 'onnat-extra' ),
                'not_found_in_trash' => __( 'No Templates found in Trash.', 'onnat-extra' ),
            ];

            $args   = [
                'label'               => esc_html__( 'Project Style', 'onnat-extra' ),
                'labels'              => $labels,
                'supports'            => array( 'title', 'editor' ),
                'hierarchical'        => true,
                'public'              => true,
                'show_ui'             => true,
                'show_in_admin_bar'   => true,
                'show_in_menu'        => 'false',
                'show_in_nav_menus'   => false,
                'can_export'          => false,
                'has_archive'         => false,
                'exclude_from_search' => true,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                'show_in_rest'        => true
            ];

            register_post_type( 'kinfw-project-look', $args );            
        }

        public function post_type_title_placeholder( $title_placeholder, $post ) {
            if ($post->post_type == 'kinfw-project') {
                $title_placeholder = esc_html__('Add Project Name', 'onnat-extra' );
            }

            if ($post->post_type == 'kinfw-project-look') {
                $title_placeholder = esc_html__('Add Project Style', 'onnat-extra' );
            }

            return $title_placeholder;
        }

        public function admin_menu() {
            if( !current_user_can('edit_pages') ) {
                return;
            }

            add_submenu_page(
                'edit.php?post_type=kinfw-project',
                esc_html__( 'Single Styles', 'onnat-extra' ),
                esc_html__( 'Single Styles', 'onnat-extra' ),
                'manage_options',
                'edit.php?post_type=kinfw-project-look',
                '',
                40
            );

            remove_meta_box( 'pageparentdiv', 'kinfw-project-look', 'normal' );
        }

        public function admin_parent_file( $parent_file ) {
            global $submenu_file, $current_screen;

            if( $current_screen->post_type == "kinfw-project-look" ) {
                $parent_file  = 'edit.php?post_type=kinfw-project';
                $submenu_file = 'edit.php?post_type=kinfw-project-look';
            }

            return $parent_file;
        }

        public function remove_view_link( $actions, $post ) {
            if ( $post->post_type === 'kinfw-project-look' ) {
                $actions['view'] = sprintf(
                    '<a href="%1$s" rel="bookmark" aria-label="%2$s" title="%2$s" target="_blank">%3$s</a>',
                    esc_url( add_query_arg( 'kfw-preview', $post->ID, get_permalink( $this->latest_post_id ) ) ),
                    esc_attr( sprintf( __( 'Project Single Template &#8220;%s&#8221; Preview', 'onnat-extra' ), $post->post_title ) ),
                    esc_html__('Preview Template', 'onnat-extra' )
                );
            }

            return $actions;
        }
        
        public function load_template( $template ) {
            global $post;
            $type = $post->post_type;

            if ( 'kinfw-project-look' === $type ) {
                $template = KFE_CONST_DIR . 'libraries/framework/single/single-kinfw-project-style.php';
            }

            /**
             * To load Elementor in single post - when Elementor Layout selected for single blog post.
             */
            if( 'kinfw-project' === $type && defined( 'ELEMENTOR_VERSION' ) ) {
                $post_id    = $post->ID;
                $meta       = get_post_meta( $post_id, '_kinfw_cpt_options', true );
                $post_style = isset( $meta['post_style'] ) ? $meta['post_style'] : 'theme_post_style';

                $template_id = 0;

                if( 'theme_post_style' === $post_style ) {
                    $template_id = (int) kinfw_onnat_theme_options()->kinfw_get_option( 'single_kinfw_project_style' );

                } else if ( 'custom_post_style' === $post_style ) {
                    $template_id = isset( $meta['custom_post_style'] ) ? (int) $meta['custom_post_style'] : 0;
                }

                if( $template_id ) {
                    $preview = \Elementor\Plugin::$instance->preview->is_preview_mode();
                    $editor  = \Elementor\Plugin::$instance->editor->is_edit_mode();

                    if( $preview || $editor ) {
                        $template = KFE_CONST_DIR . 'libraries/framework/single/single-kinfw-project.php';
                    }
                }
            }

            return $template;
        }
        
        /**
         * Filters the path of the current template before including it.
         */
        public function custom_template( $template ) {
            if( is_singular( 'kinfw-project' ) && isset( $_GET['kfw-preview'] ) ) {
                $template = KFE_CONST_DIR . 'libraries/framework/single/single-kinfw-project-preview.php';
            }

            return $template;
        }

        public function page_templates( $post_templates ) {
            $post_templates['theme_global_template']  = esc_html__('- Global Theme Option -','onnat-extra');

            return $post_templates;
        }

        public function add_template_metabox( $post_types ) {
            array_push( $post_types, "kinfw-project" );
            return $post_types;
        }

        public function add_extra_metabox() {

            /**
             * Post Style
             */
            $options = [
                '' => esc_html__('Default','onnat'),
            ];

            if( defined( 'ELEMENTOR_VERSION' ) ) {
                $posts = get_posts([
                    'post_type'      => 'kinfw-project-look',
                    'post_status'    => 'publish',
                    'posts_per_page' => -1,
                ]);

                if( count( $posts  ) > 0 ) {
                    $template_styles = [];

                    foreach ( $posts as $post ) {
                        $template_styles[ $post->ID ] = $post->post_title;
                    }

                    $options = [
                        esc_html__('Presets','onnat') =>  $options,
                    ];

                    if( count( $template_styles ) > 0 ) {
                        $options [ esc_html__('Elementor Templates','onnat') ] = $template_styles;
                    }
                }
            }

            CSF::createSection( '_kinfw_cpt_options', [
                'title'     => esc_html__( 'Post Style', 'onnat-extra' ),
                'post_type' => [ 'kinfw-project' ],
                'fields'    => [
                    [
                        'type'    => 'subheading',
                        'content' => esc_html__( 'Post Style Setting', 'onnat-extra'),
                    ],
                    [
                        'id'      => 'post_style',
                        'type'    => 'button_set',
                        'title'   => esc_html__('Post Style','onnat'),
                        'default' => 'theme_post_style',
                        'options' => [
                            'theme_post_style'  => esc_html__('Theme Option','onnat'),
                            'custom_post_style' => esc_html__('Customize','onnat'),
                        ],
                    ],
                    [
                        'id'         => 'custom_post_style',
                        'type'       => 'select',
                        'title'      => esc_html__('Custom Post Style','onnat'),
                        'default'    => 'style-1',
                        'attributes' => [ 'style' => 'width:25%' ],
                        'dependency' => [ 'post_style', '==', 'custom_post_style' ],
                        'options'    => $options,
                    ],
                ],
            ] );

            /**
             * Project Meta
             */
            CSF::createMetabox( '_kinfw_cpt_project_options', [
                'title'     => esc_html__( 'Project Meta', 'onnat-extra' ),
                'post_type' => [ 'kinfw-project' ],
                'context'   => 'normal',
                'priority'  => 'default'
            ] );

            CSF::createSection( '_kinfw_cpt_project_options', [
                'title'  => esc_html__( 'General', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'    => 'text',
                        'id'      => 'customer',
                        'title'   => esc_html__( 'Customer', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'      => 'datetime',
                        'id'        => 'datetime',
                        'title'     => esc_html__( 'Date', 'onnat-extra'),
                        'from_to'   => true,
                        'text_from' => esc_html__( 'Begin', 'onnat-extra'),
                        'text_to'   => esc_html__( 'End', 'onnat-extra'),
                        'settings'  => [
                            'enableTime' => false
                        ]
                    ],
                    [
                        'id'      => 'rating',
                        'title'   => esc_html__( 'Rating', 'onnat-extra' ),
                        'type'    => 'slider',
                        'min'     => .5,
                        'step'    => .5,
                        'max'     => 5,
                        'default' => 3,
                    ],
                    [
                        'type'      => 'link',
                        'id'        => 'website',
                        'title'     => esc_html__( 'Website', 'onnat-extra'),
                        'add_title' => esc_html__( 'Add Website', 'onnat-extra'),
                        'default'   => [],
                    ],
                ]
            ] );

            CSF::createSection( '_kinfw_cpt_project_options', [
                'title'  => esc_html__( 'Social Links', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'    => 'text',
                        'id'      => 'facebook',
                        'title'   => esc_html__( 'Facebook', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'twitter',
                        'title'   => esc_html__( 'Twitter', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'linkedin',
                        'title'   => esc_html__( 'LinkedIn', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'youtube',
                        'title'   => esc_html__( 'Youtube', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'instagram',
                        'title'   => esc_html__( 'Instagram', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'flickr',
                        'title'   => esc_html__( 'Flickr', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'pinterest',
                        'title'   => esc_html__( 'Pinterest', 'onnat-extra'),
                        'default' => ''
                    ],
                    [
                        'type'    => 'text',
                        'id'      => 'xing',
                        'title'   => esc_html__( 'Xing', 'onnat-extra'),
                        'default' => ''
                    ],
                ]
            ] );

            CSF::createSection( '_kinfw_cpt_project_options', [
                'title'  => esc_html__( 'Masonry', 'onnat-extra' ),
                'fields' => [
                    [
                        'type'    => 'button_set',
                        'id'      => 'masonry_layout_mode',
                        'title'   => esc_html__('Layout Mode?','onnat-extra'),
                        'options' => [
                            'kinfw-masonry-item kinfw-col-lg-3 kinfw-col-md-6 kinfw-col-12' => esc_html__( '1/4 Columns', 'onnat-extra'),
                            'kinfw-masonry-item kinfw-col-lg-6 kinfw-col-md-6 kinfw-col-12' => esc_html__( '2/4 Columns', 'onnat-extra'),
                            'kinfw-masonry-item kinfw-col-lg-9 kinfw-col-md-6 kinfw-col-12' => esc_html__( '3/4 Columns', 'onnat-extra'),
                            'kinfw-masonry-item kinfw-col-12'                               => esc_html__( '1 Column', 'onnat-extra'),
                        ],
                        'default' => 'kinfw-masonry-item kinfw-col-lg-6 kinfw-col-md-6 kinfw-col-12',
                    ],
                    [
                        'id'      => 'masonry_img',
                        'title'   => esc_html__( 'Image', 'onnat-extra' ),
                        'type'    => 'media',
                        'url'     => false,
                        'library' => 'image',
                    ],
                ],
            ] );

        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_project' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_project() {

        return KinForce_Extra_Plugin_CPT_Project::get_instance();
    }
}

kf_extra_plugin_cpt_project();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */