<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Service' ) ) {

	/**
	 * Define the service custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Service {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'init', [ $this, 'init' ] );
            /**
             * Filter to modify the checkbox to radio button
             */
            add_filter( 'kinfw-filter/plugin/radio-buttons-for-taxonomies', [ $this, 'update_tax_metabox' ] );
            add_filter( 'kinfw-filter/plugin/radio-buttons-for-taxonomies/no-term-kinfw-service-group', '__return_true' );

            add_filter( 'theme_kinfw-service_templates', [ $this, 'page_templates' ] );

            add_filter( 'kinfw-filter/theme/metabox/template/post-type', [ $this, 'add_template_metabox' ] );

            add_filter( 'enter_title_here', [ $this, 'post_type_title_placeholder' ], 10, 2 );

        }

        public function init() {

            /**
             * Register Custom Post Type
             */
                $service_cpt_slug   = 'kinfw-service';
                $service_group_slug = 'kinfw-service-group';

                $labels = [
                    'name'                  => esc_html__( 'Services', 'onnat-extra' ),
                    'singular_name'         => esc_html__( 'Service', 'onnat-extra' ),
                    'menu_name'             => esc_html__( 'Services', 'onnat-extra' ),
                    'name_admin_bar'        => esc_html__( 'Service', 'onnat-extra' ),
                    'add_new'               => esc_html__( 'Add New Service', 'onnat-extra' ),
                    'add_new_item'          => esc_html__( 'Add New Service', 'onnat-extra' ),
                    'new_item'              => esc_html__( 'New Template', 'onnat-extra' ),
                    'edit_item'             => esc_html__( 'Edit Template', 'onnat-extra' ),
                    'view_item'             => esc_html__( 'View Template', 'onnat-extra' ),
                    'all_items'             => esc_html__( 'All Services', 'onnat-extra' ),
                    'search_items'          => esc_html__( 'Search Templates', 'onnat-extra' ),
                    'parent_item_colon'     => esc_html__( 'Parent Templates:', 'onnat-extra' ),
                    'not_found'             => esc_html__( 'No Templates found.', 'onnat-extra' ),
                    'not_found_in_trash'    => esc_html__( 'No Templates found in Trash.', 'onnat-extra' ),
                    'featured_image'        => esc_html__( 'Service Image', 'onnat-extra' ),
                    'set_featured_image'    => esc_html__( 'Set Service Image', 'onnat-extra' ),
                    'remove_featured_image' => esc_html__( 'Remove Service Image', 'onnat-extra' ),
                    'use_featured_image'    => esc_html__( 'Use as Service Image', 'onnat-extra' ),
                ];

                $args   = [
                    'label'               => esc_html__( 'Service', 'onnat-extra' ),
                    'labels'              => $labels,
                    'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
                    'hierarchical'        => false,
                    'public'              => true,
                    'show_ui'             => true,
                    'show_in_admin_bar'   => true,
                    'show_in_menu'        => true,
                    'show_in_nav_menus'   => true,
                    'menu_icon'           => 'dashicons-insert',
                    'can_export'          => false,
                    'has_archive'         => false,
                    'exclude_from_search' => false,
                    'publicly_queryable'  => true,
                    'capability_type'     => 'page',
                    'show_in_rest'        => true,
                    'rewrite'             => [ 'slug' => esc_attr($service_cpt_slug) ],
                ];

                register_post_type( 'kinfw-service', $args );

            /**
             * Register Custom Taxonomy
             */
                $labels   = [
                    'name'                       => _x( 'Service Groups', 'Taxonomy General Name', 'onnat-extra' ),
                    'singular_name'              => _x( 'Service Group', 'Taxonomy Singular Name', 'onnat-extra' ),
                    'menu_name'                  => __( 'Service Group', 'onnat-extra' ),
                    'all_items'                  => __( 'All Service Groups', 'onnat-extra' ),
                    'parent_item'                => __( 'Parent Service Group', 'onnat-extra' ),
                    'parent_item_colon'          => __( 'Parent Service Group:', 'onnat-extra' ),
                    'new_item_name'              => __( 'New Service Group', 'onnat-extra' ),
                    'add_new_item'               => __( 'Add New Service Group', 'onnat-extra' ),
                    'edit_item'                  => __( 'Edit Service Group', 'onnat-extra' ),
                    'update_item'                => __( 'Update Service Group', 'onnat-extra' ),
                    'view_item'                  => __( 'View Service Group', 'onnat-extra' ),
                    'separate_items_with_commas' => __( 'Separate items with commas', 'onnat-extra' ),
                    'add_or_remove_items'        => __( 'Add or remove Service Groups', 'onnat-extra' ),
                    'choose_from_most_used'      => __( 'Choose from the most used', 'onnat-extra' ),
                    'popular_items'              => __( 'Popular Service Groups', 'onnat-extra' ),
                    'search_items'               => __( 'Search Service Groups', 'onnat-extra' ),
                    'not_found'                  => __( 'Not Found', 'onnat-extra' ),
                    'no_terms'                   => __( 'No Service Groups', 'onnat-extra' ),
                    'items_list'                 => __( 'Service Groups list', 'onnat-extra' ),
                    'items_list_navigation'      => __( 'Service Groups list navigation', 'onnat-extra' ),
                ];

                $tax_args = [
                    'labels'            => $labels,
                    'hierarchical'      => false,
                    'public'            => true,
                    'show_ui'           => true,
                    'show_admin_column' => true,
                    'query_var'         => true,
                    'rewrite'           => [ 'slug' => esc_attr($service_group_slug) ],
                ];

                register_taxonomy( 'kinfw-service-group', [ 'kinfw-service' ], $tax_args );
        }

        public function update_tax_metabox( $taxonomies ) {
            array_push( $taxonomies, 'kinfw-service-group' );

            return $taxonomies;
        }

        public function page_templates( $post_templates ) {
            $post_templates['theme_global_template']  = esc_html__('- Global Theme Option -','onnat-extra');

            return $post_templates;
        }

        public function add_template_metabox( $post_types ) {
            array_push( $post_types, "kinfw-service" );
            return $post_types;
        }

        public function post_type_title_placeholder( $title_placeholder, $post ) {
            if ($post->post_type == 'kinfw-service') {
                $title_placeholder = esc_html__('Add Service Name', 'onnat-extra' );
            }

            return $title_placeholder;
        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_service' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_service() {

        return KinForce_Extra_Plugin_CPT_Service::get_instance();
    }
}

kf_extra_plugin_cpt_service();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */