<?php
/**
 * The template for displaying kinforce project.
 */
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

\Elementor\Plugin::$instance->frontend->add_body_class( 'elementor-template-canvas kinfw-single-blog-post-content' );
?>
<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />

        <?php if ( ! current_theme_supports( 'title-tag' ) ) : ?>
		    <title><?php echo wp_get_document_title(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></title>
        <?php endif; ?>

        <?php wp_head(); ?>
    </head>

    <body <?php body_class(); ?>>
        <?php
            wp_body_open();

            /**
             * Before canvas page template content.
             */
            do_action( 'elementor/page_templates/canvas/before_content' );

            \Elementor\Plugin::$instance->modules_manager->get_modules( 'page-templates' )->print_content();

            /**
             * After canvas page template content.
             */
            do_action( 'elementor/page_templates/canvas/after_content' );
        ?>

        <?php wp_footer(); ?>
    </body>
</html>