<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_i18n' ) ) {

	/**
	 * Define the locale for this plugin for internationalization.
	 */
    class KinForce_Extra_Plugin_i18n {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

			/**
			 * previous hook was 'plugins_loaded', after WordPress 6.7.1 - it should be 'init'
			 */
			add_action( 'init', [ $this, 'load_plugin_textdomain' ] );

            do_action( 'kinfw-action/plugin/i18n/loaded' );

        }

		/**
		 * Load plugin textdomain for i18n.
		 */
		public function load_plugin_textdomain() {

			load_plugin_textdomain( 'onnat-extra', false, plugin_basename( dirname( KFE_CONST_FILE ) ) . '/languages');

		}

    }

}

if( !function_exists( 'kf_extra_plugin_i18n' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_i18n() {

        return KinForce_Extra_Plugin_i18n::get_instance();
    }
}

kf_extra_plugin_i18n();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */